const fs = require('fs');

// Read the index.html file
const indexHtmlPath = '../Uhelp/public/client/index.html';
const indexHtmlContent = fs.readFileSync(indexHtmlPath, 'utf-8');

// // Replace the script tags with modified src attributes
// const modifiedIndexHtmlContent = indexHtmlContent.replace(/<script src="(.+?)"/g, '<script src="client/$1"');

// // Replace the link tags with modified href attributes
// const modifiedIndexHtmlContentWithCss = modifiedIndexHtmlContent.replace(/<link rel="stylesheet" href="(.+?\.css)"/g, '<link rel="stylesheet" href="client/$1"');
// const modifiedIndexHtmlContentWithCssChunk = modifiedIndexHtmlContentWithCss.replace(/<link rel="modulepreload" href="(.+?\.js)"/g, '<link rel="modulepreload" href="client/$1"');

// Replace the script tags with modified src attributes
const modifiedIndexHtmlContent = indexHtmlContent.replace(
    /<script src="(?!client\/)(.+?)"/g, 
    '<script src="client/$1"'
  );
  
  // Replace the link tags with modified href attributes
  const modifiedIndexHtmlContentWithCss = modifiedIndexHtmlContent.replace(
    /<link rel="stylesheet" href="(?!client\/)(.+?\.css)"/g, 
    '<link rel="stylesheet" href="client/$1"'
  );
  
  // Replace the module preload link tags with modified href attributes
  const modifiedIndexHtmlContentWithCssChunk = modifiedIndexHtmlContentWithCss.replace(
    /<link rel="modulepreload" href="(?!client\/)(.+?\.js)"/g, 
    '<link rel="modulepreload" href="client/$1"'
  );

  
// Replace window['$BaseVal'] with dynamic value
const baseGlobal = modifiedIndexHtmlContentWithCssChunk.replace(/window\['\$BaseVal'\]\s*=\s*`\/`;/g, 'window[\'$BaseVal\'] = `{{$BaseVal}}`;');

// Replace <base href="/"> with <base href="{{$BaseVal}}">
const baseHref = baseGlobal.replace(/<base href="\/">/g, '<base href="{{$BaseVal}}">');


// Write the modified index.html content back to the file
fs.writeFileSync(indexHtmlPath, baseHref);
