import { Component, OnInit } from '@angular/core';
import { Title, Meta } from '@angular/platform-browser';
import { ActivatedRoute, NavigationEnd, Router, RouterOutlet } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { takeUntil } from 'rxjs';
import { AdminService } from './shared/services/admin/admin.service';
import { LoaderService } from './shared/services/loader.service';
import { Unsub } from './shared/class/unsub.class';
import { TimeoutGuard } from './shared/guard/timeout.guard';

@Component({
	selector: 'app-root',
	standalone: true,
	imports: [RouterOutlet],
	templateUrl: './app.component.html',
	styleUrl: './app.component.scss'
})
export class AppComponent extends Unsub implements OnInit {
	res;
	url = "";
	liveChatCustomers;
	constructor(
		private titleService: Title,
		private timeoutGuard: TimeoutGuard,
		private meta: Meta,
		private router: Router,
		private route: ActivatedRoute,
		public translate: TranslateService,
		private adminService: AdminService, loaderService: LoaderService
	) {
		super(loaderService);
		const lang = localStorage.getItem('lang');
		translate.use(lang || 'en');


		this.router.events.pipe(takeUntil(this.unSubscribe$)).subscribe({
			next: (event: any) => {
				if (event instanceof NavigationEnd) {
					let gurad$: any = this.timeoutGuard.canActivate(this.route.snapshot, this.router.routerState.snapshot)
					gurad$.subscribe();
				}
			}
		})
		this.url = location.origin + document.querySelector('base')?.getAttribute('href');
	}
	ngOnInit() {
		this.adminService.RefreshRquestAdmin$.pipe(
			takeUntil(this.unSubscribe$)
		).subscribe({
			next: () => {
				this.basic();
			},
		});
	}

	//For Seo
	basic() {
		this.adminService.basic().pipe(takeUntil(this.unSubscribe$)).subscribe({
			next: (ele) => {
				this.res = ele.body;
				this.liveChatCustomers = ele.body?.liveChatCustomers;
				if (ele.body && ele.headers) {
					ele = ele.body;
				}
				if (ele.setting?.original?.default_lang && !localStorage.getItem('lang')) {
					this.translate.use(ele.setting?.original?.default_lang);
				}
				this.translate.get('is_rtl').subscribe({
					next: (res) => {
						if (res == 1) {
							document.documentElement?.setAttribute('dir', 'rtl');
							document.body?.classList.add('rtl');
						} else {
							document.documentElement?.removeAttribute('dir');
							document.body?.classList.remove('rtl');
						}
					}
				})
				if (ele?.users?.darkmode == 1 && ele?.SPRUKOADMIN_P == 'on') {
					document.body.classList.add('dark-mode');
				}
				else if (ele?.users?.darkmode == 0 && ele?.SPRUKOADMIN_P == 'on') {
					document.body.classList.remove('dark-mode');
				}
				else if (ele?.customer?.custsetting?.darkmode == 1 && ele?.SPRUKOADMIN_C == 'on') {
					document.body.classList.add('dark-mode');
				}
				else if (ele?.customer?.custsetting?.darkmode == 0 && ele?.SPRUKOADMIN_C == 'on') {
					document.body.classList.remove('dark-mode');
				}
				else if (ele.setting?.original?.DARK_MODE == 1) {
					document.body.classList.add('dark-mode');
				}
				else {
					document.body.classList.remove('dark-mode');
				}
				//set title

				this.titleService.setTitle(ele?.title?.title);
				//fav
				const favIcon: any = document.querySelector('#faviconDynamically');
				favIcon.href = ele?.title?.logoimage4;

				// set meta tags
				this.meta.addTag({ name: 'author', content: ele.seopage?.author });
				this.meta.addTag({
					name: 'description',
					content: ele.seopage?.description,
				});
				this.meta.addTag({ name: 'keywords', content: ele.seopage?.keywords });

				//Add CSS and Js

				//Add CSS
				const styleNode = document.createElement('style');
				styleNode.type = 'text/css';
				styleNode.id = 'customStyle';
				if (ele?.CUSTOMCSS) {
					const styleText = document.createTextNode(ele?.CUSTOMCSS);
					styleNode.appendChild(styleText);
					if (!document.getElementById('customStyle')) {
						document.getElementsByTagName('body')[0].appendChild(styleNode);
					} else {
						const eleForcss: any = document.getElementById('customStyle');
						eleForcss.innerText = ele?.CUSTOMCSS;
					}
				} else {
					document.getElementById('customStyle')?.remove();
				}

				//Add JS
				if (document.getElementById('customScript')) {
					document.getElementById('customScript')?.remove();
				}
				const ScriptNode = document.createElement('script');
				ScriptNode.type = 'text/javascript';
				ScriptNode.id = 'customScript';
				if (ele?.CUSTOMJS) {
					const ScriptText = document.createTextNode(ele?.CUSTOMJS);
					ScriptNode.appendChild(ScriptText);
					document.getElementsByTagName('body')[0].appendChild(ScriptNode);
				}

				this.dynamicLightPrimaryColor(ele.setting?.original?.theme_color);
				this.dynamicSecondaryColor(ele.setting?.original?.theme_color_dark);
				localStorage.setItem('title', ele?.title?.title);
				localStorage.setItem('primarycolor', ele.setting?.original?.theme_color);
				localStorage.setItem('secoundrycolor', ele.setting?.original?.theme_color_dark);

				if (ele.setting?.original?.GOOGLEFONT_DISABLE == 'off') {
					if (!document.querySelector('#googleFont')) {
						const styleTag = document.createElement('link');
						styleTag.id = "googleFont";
						styleTag.rel = 'stylesheet';
						styleTag.href = 'https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap';
						document.head.appendChild(styleTag);
					}
				} else {
					if (document.querySelector('#googleFont')) {
						document.querySelector('#googleFont')?.remove();
					}
				}

				if (ele.setting?.original?.GOOGLE_ANALYTICS_ENABLE == 'yes') {
					// <!-- Global site tag (gtag.js) - Google Analytics -->
					const googleAnal = `<script id="google-analytics" async src = "https://www.googletagmanager.com/gtag/js?id=${ele.setting?.original?.GOOGLE_ANALYTICS}" > </script>
              <script> window.dataLayer = window.dataLayer || []; function gtag() { dataLayer.push(arguments); } gtag('js', new Date()); gtag('config', '${ele.setting?.original?.GOOGLE_ANALYTICS}'); </script>`;
					if (!document.querySelector('#google-analytics')) {
						document.body.insertAdjacentHTML('beforeend', googleAnal);
					}
				}
				else {
					if (document.querySelector('#google-analytics')) {
						document.querySelector('#google-analytics')?.remove();
						document.querySelector('#google-analytics')?.nextElementSibling?.remove();
					}
				}
			},
		});
	}

	//For the Color change
	handleThemeUpdate(cssVars: any) {
		const root: any = document.querySelector(':root');
		const keys = Object.keys(cssVars);

		keys.forEach((key) => {
			root.style.setProperty(key, cssVars[key]);
		});
	}

	// to check the value is hexa or not
	isValidHex = (hexValue: any) => /^#([A-Fa-f0-9]{3,4}){1,2}$/.test(hexValue);

	getChunksFromString = (st: any, chunkSize: any) =>
		st.match(new RegExp(`.{${chunkSize}}`, 'g'));
	// convert hex value to 256
	convertHexUnitTo256 = (hexStr: any) =>
		parseInt(hexStr.repeat(2 / hexStr.length), 16);
	// get alpha value is equla to 1 if there was no value is asigned to alpha in function
	getAlphafloat = (a: any, alpha: any) => {
		if (typeof a !== 'undefined') {
			return a / 255;
		}
		if (typeof alpha != 'number' || alpha < 0 || alpha > 1) {
			return 1;
		}
		return alpha;
	};

	hexToRgba(hexValue: any, alpha = 1) {
		if (!this.isValidHex(hexValue)) {
			return null;
		}
		const chunkSize = Math.floor((hexValue.length - 1) / 3);
		const hexArr = this.getChunksFromString(hexValue.slice(1), chunkSize);
		const [r, g, b, a] = hexArr.map(this.convertHexUnitTo256);
		return `rgba(${r}, ${g}, ${b}, ${this.getAlphafloat(a, alpha)})`;
	}

	// convertion of hex code to rgba code

	dynamicLightPrimaryColor(color: any) {
		const cssPropName = `--primary`;
		if (color?.match('#')) {
			this.handleThemeUpdate({
				[cssPropName]: this.hexToRgba(color),
			});
		} else {
			this.handleThemeUpdate({
				[cssPropName]: color,
			});
		}
	}

	dynamicSecondaryColor(color: any) {
		const cssPropName = `--secondary`;
		if (color?.match('#')) {
			this.handleThemeUpdate({
				[cssPropName]: this.hexToRgba(color),
			});
		} else {
			this.handleThemeUpdate({
				[cssPropName]: color,
			});
		}
	}
	intervalId;
	onlineUsersFindChannel;
    vibrateTwoTimes = () => {
        if ('vibrate' in navigator) {
            try {
                window.navigator.vibrate([1000]);
            } catch (error) {
                console.error('Vibration API error:', error);
            }
        }
    }
	notifyGroup(socket) {
		this.vibrateTwoTimes();
		navigator.vibrate([500, 500]);
		navigator.serviceWorker.ready.then(function (registration) {
			registration.showNotification(socket.senderName, {
				body: socket.message,
				icon: this.url + `/uploads/profile/group.png`,
				data: {
					link: this.url + `/admin/operators`
				}
			});
		})
	}
	notifyoperator(socket) {
		this.vibrateTwoTimes();
		navigator.vibrate([500, 500]);
		navigator.serviceWorker.ready.then(function (registration) {
			registration.showNotification(socket.senderName, {
				body: socket.message,
				icon: 
					this.url + `/uploads/profile/user-profile.png`, 
				data: {
					link: this.url + `/admin/operators`
				}
			});
		})
	}
	notifychat(socket) {
		this.vibrateTwoTimes();
		navigator.vibrate([500, 500]);
		navigator.serviceWorker.ready.then(function (registration) {
			registration.showNotification(socket.userName, {
				body: socket.message,
				icon: this.url + `/uploads/profile/user-profile.png`,
				data: {
					link: this.url + `/admin/liveChat/myopened-chats`
				}
			});
		})
	}
	notifynewchat(socket) {
		this.vibrateTwoTimes();
		navigator.vibrate([500, 500]);
		navigator.serviceWorker.ready.then(function (registration) {
			registration.showNotification(socket.userName, {
				body: socket.message,
				icon: this.url + `/uploads/profile/user-profile.png`,
				data: {
					link: this.url + `/admin/livechat/newchats`
				}
			});
		})

	}
	newMessageSoundCurrentAudio: HTMLAudioElement | null = null;
  
	ngAfterViewInit(): void {
		//LiveChat  Online users induction logic
		this.onlineUsersFindChannel = (window as any).Echo?.join('angularagentMessage');
		// For the Operators Notifications
		this.onlineUsersFindChannel?.listen('AgentMessageEvent', (socket) => {

            // For the Agent To Agent Chat
            if (this.res.AuthId == socket.receiverId && !socket.groupInclude && socket.message &&
                this.res.setting?.original?.operatorsAgentToAgentSound && parseInt(this.res.setting?.original?.operatorsAgentToAgentWebNot) && parseInt(
                    this.res.setting?.original?.operatorsNotificationsSounds)) {

                // For the Window notification
                if ("Notification" in window) {
                    if (Notification.permission === "granted") {
                        this.notifyoperator(socket);
                    } else {
                        Notification.requestPermission().then(res => {
                            if (res === "granted") {
                                this.notifyoperator(socket);
                            } else {
                                console.error("Did not receive permission for notifications");
                            }
                        })
                    }
                } else {
                    console.error("Browser does not support notifications");
                }

                // Stop the current audio if it exists
                if (this.newMessageSoundCurrentAudio) {
                    this.newMessageSoundCurrentAudio.pause();
                    this.newMessageSoundCurrentAudio.currentTime = 0;
                }

                // Create a new audio element
                let audioElement = document.createElement('audio');
                audioElement.id = "audioPlayer";
                audioElement.innerHTML = `
                        <source src=this.url + "/uploads/livechatsounds/${this.res.setting?.original?.operatorsAgentToAgentSound}">
                    `;

                // Play the new audio
                if (audioElement.paused) {
                    audioElement.play();
                    this.vibrateTwoTimes();
                }
                this.newMessageSoundCurrentAudio = audioElement;

            }


            // For the Grop messages
            if (socket.groupInclude && socket.groupInclude.includes(parseInt(this.res.AuthId)) &&
                socket.message && this.res.setting?.original?.operatorsGroupChatSound && parseInt(this.res.setting?.original?.operatorsGroupChatWebNot) &&
                parseInt(this.res.setting?.original?.operatorsNotificationsSounds) && socket.senderId != parseInt(this.res.AuthId)) {

                // For the Window notification
                if ("Notification" in window) {
                    if (Notification.permission === "granted") {
                        this.notifyGroup(socket);
                    } else {
                        Notification.requestPermission().then(res => {
                            if (res === "granted") {
                                this.notifyGroup(socket);
                            } else {
                                console.error("Did not receive permission for notifications");
                            }
                        })
                    }
                } else {
                    console.error("Browser does not support notifications");
                }

                // Stop the current audio if it exists
                if (this.newMessageSoundCurrentAudio) {
                    this.newMessageSoundCurrentAudio.pause();
                    this.newMessageSoundCurrentAudio.currentTime = 0;
                }

                // Create a new audio element
                let audioElement = document.createElement('audio');
                audioElement.id = "audioPlayer";
                audioElement.innerHTML = `
                        <source src=this.url + "/uploads/livechatsounds/${this.res.setting?.original?.operatorsGroupChatSound}">
                    `;

                // Play the new audio
                if (audioElement.paused) {
                    audioElement.play();
                    this.vibrateTwoTimes();
                }
                this.newMessageSoundCurrentAudio = audioElement;
            }
		});
		(window as any).Echo?.channel('angularliveChat').listen('ChatMessageEvent', (socket) => {

            // For the New Chat request
            if (socket.message == "newUser" && parseInt(this.res.setting?.original?.notificationsSounds) && parseInt(
                this.res.setting?.original?.newChatRequestWebNot)) {
                // For the Window notification
                if ("Notification" in window) {
                    if (Notification.permission === "granted") {
                        this.notifynewchat(socket);
                    } else {
                        Notification.requestPermission().then(res => {
                            if (res === "granted") {
                                this.notifynewchat(socket);
                            } else {
                                console.error("Did not receive permission for notifications");
                            }
                        })
                    }
                } else {
                    console.error("Browser does not support notifications");
                }


                // Stop the current audio if it exists
                if (this.newMessageSoundCurrentAudio) {
                    this.newMessageSoundCurrentAudio.pause();
                    this.newMessageSoundCurrentAudio.currentTime = 0;
                }

                // Create a new audio element
                let audioElement = document.createElement('audio');
                audioElement.id = "audioPlayer";
                audioElement.innerHTML = `
                    <source src="${this.url}/uploads/livechatsounds/${this.res.setting?.original?.newChatRequestSound}">
                `;

                // Play the new audio
                if (audioElement.paused) {
                    audioElement.play();
                    this.vibrateTwoTimes();
                }
                this.newMessageSoundCurrentAudio = audioElement;
                this.newMessageSoundCurrentAudio['cusumerId'] = socket.id


                // Function to check localStorage value and play or stop the audio
                if (this.res.setting?.original?.notificationType == "Loop") {
                    function checkAndPlaySound() {
                        if (localStorage?.['livechatCustomer'] == this.newMessageSoundCurrentAudio.__proto__.cusumerId) {
                            if (!audioElement.paused) {
                                audioElement.pause();
                            }
                            clearInterval(intervalId);
                        } else {
                            if (audioElement.paused) {
                                audioElement.play();
                                this.vibrateTwoTimes();
                            }
                        }
                    }

                    let intervalId = setInterval(checkAndPlaySound, 1000);
                }
            }

            // For the New message
            if (parseInt(this.res.setting?.original?.notificationsSounds) && parseInt(this.res.setting?.original?.newMessageWebNot)) {
                this.liveChatCustomers.forEach((ele) => {
                    if (ele.id == socket.id && !socket.agentInfo) {
                        try {
                            if ((ele.engage_conversation == null && socket.message) || (ele.engage_conversation && ele.engage_conversation.some(item => item.id == this.res.AuthId))) {

                                if ("Notification" in window) {
                                    if (Notification.permission === "granted") {
                                        this.notifyoperator(socket);
                                    } else {
                                        Notification.requestPermission().then(res => {
                                            if (res === "granted") {
                                                this.notifyoperator(socket);
                                            } else {
                                                console.error(
                                                    "Did not receive permission for notifications"
                                                );
                                            }
                                        })
                                    }
                                } else {
                                    console.error("Browser does not support notifications");
                                }


                                // Stop the current audio if it exists
                                if (this.newMessageSoundCurrentAudio) {
                                    this.newMessageSoundCurrentAudio.pause();
                                    this.newMessageSoundCurrentAudio.currentTime = 0;
                                }

                                // Create a new audio element
                                let audioElement = document.createElement('audio');
                                audioElement.id = "audioPlayer";
                                audioElement.innerHTML = `<source src="${this.url}/uploads/livechatsounds/${this.res.setting?.original?.newMessageSound}">`;
                                // Play the new audio
                                if (audioElement.paused) {
                                    audioElement.play();
                                    this.vibrateTwoTimes();
                                }

                                // Set the new audio as the current audio
                                this.newMessageSoundCurrentAudio = audioElement;
                                this.newMessageSoundCurrentAudio['cusumerId'] = socket.id

                                // To remove the Sound the chatBody click
                                if (this.res.setting?.original?.notificationType == "Loop") {
                                    const clickEventHandler = () => {
                                        this.newMessageSoundCurrentAudio.pause();
                                        clearInterval(this.intervalId);
                                        document.querySelector(
                                            `#operator-conversation-Info[data-id="${socket.id}"]`
                                        ).closest('.main-chat-area')
                                            .removeEventListener('click', clickEventHandler);
                                        this.intervalId = null
                                    };
                                    if (document.querySelector(
                                        `#operator-conversation-Info[data-id="${socket.id}"]`
                                    )) {
                                        document.querySelector(
                                            `#operator-conversation-Info[data-id="${socket.id}"]`
                                        ).closest('.main-chat-area').addEventListener(
                                            'click', clickEventHandler);
                                    }

                                    function checkAndPlaySound() {
                                        if (audioElement.paused) {
                                            audioElement.play();
                                            this.vibrateTwoTimes();
                                        }
                                    }

                                    if (!this.intervalId) {
                                        this.intervalId = setInterval(checkAndPlaySound, 1000);
                                    }
                                }
                            }
                        } catch (error) {
                            console.log("engage conversation not getting array", error);
                        }
                    }
                })
            }

		})
	}
}

