import { APP_INITIALIZER, ApplicationConfig, importProvidersFrom, inject, ViewContainerRef } from '@angular/core';
import { ActivatedRoute, Router, provideRouter } from '@angular/router';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';

import { routes } from './app.routes';
import { provideAnimationsAsync } from '@angular/platform-browser/animations/async';
import { HTTP_INTERCEPTORS, HttpClient, HttpClientModule } from '@angular/common/http';
import { Title, Meta, BrowserModule } from '@angular/platform-browser';
import { TranslateLoader, TranslateModule, TranslatePipe, TranslateService } from '@ngx-translate/core';
import { TranslateHttpLoader } from '@ngx-translate/http-loader';
import { AdminService } from './shared/services/admin/admin.service';
import { SharedModule } from './shared/shared.module';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { ToastrModule } from 'ngx-toastr';
import { DatePipe } from '@angular/common';
import { AuthInterceptor } from './shared/interceptor/authentication.service';
import { HttpRequestService } from './shared/interceptor/httpRequest.service';
import { Httperror } from './shared/interceptor/httperror.service';
import { LoaderService } from './shared/services/loader.service';
import { TranslatePipes } from './shared/pipes/translate/translate.pipe';
import { NgSelectModule } from '@ng-select/ng-select';
import { register } from 'swiper/element/bundle';

register();


	//For the Color change
	function handleThemeUpdate(cssVars: any) {
		const root: any = document.querySelector(':root');
		const keys = Object.keys(cssVars);

		keys.forEach((key) => {
			root.style.setProperty(key, cssVars[key]);
		});
	}

	// to check the value is hexa or not
	let isValidHex = (hexValue: any) => /^#([A-Fa-f0-9]{3,4}){1,2}$/.test(hexValue);

	let getChunksFromString = (st: any, chunkSize: any) =>
		st.match(new RegExp(`.{${chunkSize}}`, 'g'));
	// convert hex value to 256
	let convertHexUnitTo256 = (hexStr: any) =>
		parseInt(hexStr.repeat(2 / hexStr.length), 16);
	// get alpha value is equla to 1 if there was no value is asigned to alpha in function
	let getAlphafloat = (a: any, alpha: any) => {
		if (typeof a !== 'undefined') {
			return a / 255;
		}
		if (typeof alpha != 'number' || alpha < 0 || alpha > 1) {
			return 1;
		}
		return alpha;
	};

	function hexToRgba(hexValue: any, alpha = 1) {
		if (!isValidHex(hexValue)) {
			return null;
		}
		const chunkSize = Math.floor((hexValue.length - 1) / 3);
		const hexArr = getChunksFromString(hexValue.slice(1), chunkSize);
		const [r, g, b, a] = hexArr.map(convertHexUnitTo256);
		return `rgba(${r}, ${g}, ${b}, ${getAlphafloat(a, alpha)})`;
	}

	// convertion of hex code to rgba code

	function dynamicLightPrimaryColor(color: any) {
		const cssPropName = `--primary`;
		if (color?.match('#')) {
			handleThemeUpdate({
				[cssPropName]: hexToRgba(color),
			});
		} else {
			handleThemeUpdate({
				[cssPropName]: color,
			});
		}
	}

	function dynamicSecondaryColor(color: any) {
		const cssPropName = `--secondary`;
		if (color?.match('#')) {
			handleThemeUpdate({
				[cssPropName]: hexToRgba(color),
			});
		} else {
			handleThemeUpdate({
				[cssPropName]: color,
			});
		}
	}

// AoT requires an exported function for factories
export function HttpLoaderFactory(httpClient: HttpClient) {
    const timestamp = new Date().getTime();
  const apiEndpoint = 'detail/assets/i18n/';

  return new TranslateHttpLoader(httpClient, apiEndpoint, `.json?t=${timestamp}`);
}

export function init_app(adminService: AdminService, translate: TranslateService, titleService: Title, meta: Meta) {
  let router = inject(Router);
  let activatedRoute = inject(ActivatedRoute);
  return () => new Promise<void>((resolve, reject) => {
    adminService
      .basic()
      .subscribe({
        next: (res) => {
          
          var timestamp = new Date().getTime(); // Current timestamp
          if(res?.serverssldomainname == res?.domainname){
            var script = document.createElement('script');
            // Get the current path
            var current = window.location.origin + window['$BaseVal'];

            // Set the script source dynamically
            script.src = current + 'assets/livechat/web-socket.js?timestamp=' + timestamp;
            script.setAttribute('domainName', current);
            // script.src = 'https://localhost/ufinal/assets/livechat/web-socket.js?timestamp=' + timestamp;
            // script.setAttribute('domainName', 'https://localhost/ufinal');
            script.setAttribute('wsPort', '8443');
            document.body.appendChild(script);
          }
          
          let currentPath = location.pathname.replace(window['$BaseVal'], '');
          if (res.body?.redirect == "login" && (currentPath == '/' || currentPath == '')) {
            router.navigate(['/customer/login']);
          }

          let ele = res.body;
          const lang = localStorage.getItem('lang');
		      translate.use(lang || 'en');
          if (ele.setting?.original?.default_lang && !localStorage.getItem('lang')) {
		        translate.use(ele.setting?.original?.default_lang || 'en');
          }
          translate.get('is_rtl').subscribe({
            next : (res) =>{
              
              if (res == 1) {
                document.documentElement?.setAttribute('dir', 'rtl');
                document.body?.classList.add('rtl');
              } else {
                document.documentElement?.removeAttribute('dir');
                document.body?.classList.remove('rtl');
              }
            }
          })
          
          if (ele?.users?.darkmode == 1 && ele?.SPRUKOADMIN_P == 'on') {
            document.body.classList.add('dark-mode');
          }
          else if (ele?.users?.darkmode == 0 && ele?.SPRUKOADMIN_P == 'on') {
            document.body.classList.remove('dark-mode');
          }
          else if (ele?.customer?.custsetting?.darkmode == 1 && ele?.SPRUKOADMIN_C == 'on') {
            document.body.classList.add('dark-mode');
          }
          else if (ele?.customer?.custsetting?.darkmode == 0 && ele?.SPRUKOADMIN_C == 'on') {
            document.body.classList.remove('dark-mode');
          }
          else if (ele.setting?.original?.DARK_MODE == 1) {
            document.body.classList.add('dark-mode');
          }
          else {
            document.body.classList.remove('dark-mode');
          }
          //set title

          titleService.setTitle(ele?.title?.title);
            
          var inspectDisable = ele.setting?.original?.inspectDisable;
          var selectDisabled = ele.setting?.original?.selectDisabled;          
                if (inspectDisable == 'on') {
                    document.addEventListener('contextmenu', function(event) {
                        event.preventDefault();
                    });
                    document.onkeydown = function(e) {
                        if (e.code == 'F12') return;
                        if ((e.ctrlKey || e.metaKey) && e.shiftKey && (e.key === 'I' || e.key === 'C')) {
                          e.preventDefault();
                          return;
                        };
                    }
                }

                if (selectDisabled == 'on') {
                    document.addEventListener('selectstart', function(event:Event) {
                        const editableElements = ['INPUT', 'TEXTAREA', 'DIV'];
                        const isEditable = editableElements.some(tag => event.target?.['tagName'] === tag && event.target?.['isContentEditable']);

                        if (!isEditable) {
                            event.preventDefault();
                        }
                    });
                }
          //fav
          const favIcon: any = document.querySelector('#faviconDynamically');
          favIcon ? favIcon.href = ele?.title?.logoimage4 : '';

          // set meta tags
          meta.addTag({ name: 'author', content: ele.seopage?.author });
          meta.addTag({
            name: 'description',
            content: ele.seopage?.description,
          });
          meta.addTag({ name: 'keywords', content: ele.seopage?.keywords });

          //Add CSS and Js

          //Add CSS
          const styleNode = document.createElement('style');
          styleNode.type = 'text/css';
          styleNode.id = 'customStyle';
          if (ele?.CUSTOMCSS) {
            const styleText = document.createTextNode(ele?.CUSTOMCSS);
            styleNode.appendChild(styleText);
            if (!document.getElementById('customStyle')) {
              document.getElementsByTagName('body')[0].appendChild(styleNode);
            } else {
              const eleForcss: any = document.getElementById('customStyle');
              eleForcss.innerText = ele?.CUSTOMCSS;
            }
          } else {
            document.getElementById('customStyle')?.remove();
          }

          //Add JS
          if (document.getElementById('customScript')) {
            document.getElementById('customScript')?.remove();
          }
          
          const ScriptNode = document.createElement('script');
          ScriptNode.type = 'text/javascript';
          ScriptNode.id = 'customScript';
          if (ele?.CUSTOMJS) {
            const ScriptText = document.createTextNode(ele?.CUSTOMJS);
            ScriptNode.appendChild(ScriptText);
            document.getElementsByTagName('body')[0].appendChild(ScriptNode);
          }

					dynamicLightPrimaryColor(ele.setting?.original?.theme_color);
					dynamicSecondaryColor(ele.setting?.original?.theme_color_dark);
          ele.setting?.original?.title ? localStorage.setItem('title', ele?.title?.title) : '';
          ele.setting?.original?.theme_color ? localStorage.setItem('primarycolor', ele.setting?.original?.theme_color) : '';
          ele.setting?.original?.theme_color_dark ? localStorage.setItem('secoundrycolor', ele.setting?.original?.theme_color_dark) : '';

          if (ele.setting?.original?.GOOGLEFONT_DISABLE == 'off') {
            if (!document.querySelector('#googleFont')) {
              const styleTag = document.createElement('link');
              styleTag.id = "googleFont";
              styleTag.rel = 'stylesheet';
              styleTag.href = 'https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap';
              document.head.appendChild(styleTag);
            }
          } else {
            if (document.querySelector('#googleFont')) {
              document.querySelector('#googleFont')?.remove();
            }
          }

          if (ele.setting?.original?.GOOGLE_ANALYTICS_ENABLE == 'yes') {
            // <!-- Global site tag (gtag.js) - Google Analytics -->
            const googleAnal = `<script id="google-analytics" async src = "https://www.googletagmanager.com/gtag/js?id=${ele.setting?.original?.GOOGLE_ANALYTICS}" > </script>
              <script> window.dataLayer = window.dataLayer || []; function gtag() { dataLayer.push(arguments); } gtag('js', new Date()); gtag('config', '${ele.setting?.original?.GOOGLE_ANALYTICS}'); </script>`;
            if (!document.querySelector('#google-analytics')) {
              document.body.insertAdjacentHTML('beforeend', googleAnal);
            }
          }
          else {
            if (document.querySelector('#google-analytics')) {
              document.querySelector('#google-analytics')?.remove();
              document.querySelector('#google-analytics')?.nextElementSibling?.remove();
            }
          }
          let Twofactor = res.headers.get('Twofactor');
          const Google2fa = res.headers.get('Google2fa');
          const email = res.headers.get('email');
          if (Twofactor === 'customer') {
            router.navigate(['/customer/customertwofactor/' + email], {
              queryParams: {

              },
            });
          } else if (Google2fa === 'customer') {
            router.navigate(['/customer/customergoogle2fa/' + email], {
              queryParams: {

              },
            });
          }
          else if (ele?.customer) {
            if (location.pathname.match('/customer/login') || location.pathname == '/customer/') {
              router.navigate(['/customer/dashboard']);
            }
          } else {
            if (location.pathname.match('/customer/login') || location.pathname == '/customer/') {

            }
          }

          resolve();
        },
        error: (err) => {
          reject(err)
        }
      });
    // Do your initialization here
  });
}


export const appConfig: ApplicationConfig = {
  
  providers: [provideRouter(routes), 
    BrowserModule,
    BrowserAnimationsModule,
    SharedModule,
    RecaptchaModule, //this is the recaptcha main module
    RecaptchaV3Module,
    MatProgressBarModule,
    TranslatePipes,
    TranslatePipe,
    provideAnimationsAsync(),
    importProvidersFrom(
      NgSelectModule,
      ToastrModule.forRoot(), // ToastrModule added
    DatePipe,
    TranslatePipe,
    TranslatePipes,
    HttpClientModule,
    TranslateModule.forRoot({
      loader: {
        provide: TranslateLoader,
        useFactory: HttpLoaderFactory,
        deps: [HttpClient, HttpClientModule]
      }
    }),
    LoaderService,
    TranslatePipes
    ),
    
    { provide: HTTP_INTERCEPTORS, useClass: AuthInterceptor, multi: true },
    {
      provide: APP_INITIALIZER,
      useFactory: init_app,
      multi: true,
      deps: [AdminService, TranslateService, Title, Meta],
    },
    {
      provide: HTTP_INTERCEPTORS,
      useClass: HttpRequestService,
      multi: true
    },
    {
      provide: HTTP_INTERCEPTORS,
      useClass: Httperror,
      multi: true,
    },
  ]
};
