import { Routes } from '@angular/router';
import { AdminLoginComponent } from './components/admin/Auth/admin-login/admin-login.component';
import { PageNotFoundComponent } from './components/custome-error/page-not-found/page-not-found.component';
import { LoginComponent } from './components/customer/Auth/login/login.component';
import { CustomerRegisterComponent } from './components/customer/Auth/register/register.component';
import { EmailtoticketimageurlComponent } from './shared/common/emailtoticketimageurl/emailtoticketimageurl.component';
import { ImageviewComponent } from './shared/common/imageview/imageview.component';
import { RatingPageComponent } from './shared/common/rating-page/rating-page.component';
import { UserGuard } from './shared/guard/admin-auth-guard.guard';
import { CustomerAuthGuardGuard } from './shared/guard/customer-auth-guard.guard';
import { AdminLayoutComponent } from './shared/layouts/admin-layout/admin-layout.component';
import { CustomerLayoutComponent } from './shared/layouts/customer-layout/customer-layout.component';
import { ErrorLayoutComponent } from './shared/layouts/error-layout/error-layout.component';
import { GuestLayoutComponent } from './shared/layouts/guest-layout/guest-layout.component';
import { admin } from './shared/routes/admin.routes';
import { customer } from './shared/routes/customer.routes';
import { guest, errorroute } from './shared/routes/guest.routes';
import { CustomInvoiceComponent } from './components/admin/payments/custom-invoice/custom-invoice.component';
import { CustomerCustomInvoiceComponent } from './components/customer/custom-invoice/custom-invoice.component';
import { CustomInvoicePayComponent } from './components/customer/custom-invoice-pay/custom-invoice-pay.component';
import { RefundViewComponent } from './components/customer/refund-view/refund-view.component';

export const routes: Routes = [
    {
      path: '',
      component: GuestLayoutComponent,
      children: guest
    },
    {
      path: 'admin/live-chat/test-it-out/:id', loadComponent: () => import('./components/admin/liveChat/test-it-out/test-it-out.component').then(e => e.TestItOutComponent), data: {
        permission: true
      }
    },
    {
      path: 'admin',
      redirectTo: 'admin/login',
      pathMatch: 'full',
    },
    {
      path: 'customer',
      redirectTo: 'customer/login',
      pathMatch: 'full',
    },
    {
      path: 'rating-page/:id',
      component: RatingPageComponent,
    },
    {
      path: 'admin/payments/custom-invoice/:id',
      component: CustomInvoiceComponent,
    },
    {
      path: 'customer/custom-invoice/:id',
      component: CustomerCustomInvoiceComponent,
    },
    {
      path: 'customer/custom-invoice/pay/:id',
      component: CustomInvoicePayComponent,
    },
    // {
    //   path: 'customer/refund-view/:id',
    //   component: RefundViewComponent,
    // },
  
    {
      path: 'admin',
      children: [
        { path: 'forgot-password', loadComponent:()=> import('./components/admin/Auth/admin-forgot-password/admin-forgot-password.component').then(e => e.AdminForgotPasswordComponent) },
        { path: 'add-license-code', loadComponent:()=> import('./components/admin/Auth/add-license-code/add-license-code.component').then(e => e.AddLicenseCodeComponent)},
        { path: ':id/reset-password', loadComponent:()=> import('./components/admin/Auth/resetpassword/resetpassword.component').then(e => e.ResetpasswordComponent) },
        { path: 'admintwofactor/:id', loadComponent:()=> import('./components/admin/Auth/admintwofactor/admintwofactor.component').then(e => e.AdmintwofactorComponent) },
        { path: 'admingoogle2fa/:id', loadComponent:()=> import('./components/admin/Auth/admingoogle2fa/admingoogle2fa.component').then(e => e.Admingoogle2faComponent) },
        { path: 'adminemailupdate/:email', loadComponent:()=> import('./components/admin/profile/adminemailupdate/adminemailupdate.component').then(e => e.AdminemailupdateComponent), data: {permission: true}},
      ],
    },
    {
      path: 'admin',
      children: [{
        path: 'login', component: AdminLoginComponent, data: {
          permission: true
        },
      }
      ],
      canActivate: [UserGuard],
    },
    {
      path: 'customer',
      children: [
        { path: 'forgot-password', loadComponent:()=>import('./components/customer/Auth/forgot-password/forgot-password.component').then(e => e.ForgotPasswordComponent) },
        { path: ':id/reset-password', loadComponent:()=>import('./components/customer/Auth/reset-password/reset-password.component').then(e => e.ResetPasswordComponent) },
        { path: 'user/verify/:id', loadComponent:()=>import('./components/customer/Auth/customer-verify/customer-verify.component').then(e => e.CustomerVerifyComponent) },
        { path: 'customertwofactor/:id', loadComponent:()=>import('./components/customer/Auth/customertwofactor/customertwofactor.component').then(e => e.CustomertwofactorComponent) },
        { path: 'customergoogle2fa/:id', loadComponent:()=>import('./components/customer/Auth/customergoogle2fa/customergoogle2fa.component').then(e => e.Customergoogle2faComponent) },
        { path: 'customeremailupdate/:email', loadComponent:()=>import('./components/customer/editprofile/customeremailupdate/customeremailupdate.component').then(e => e.CustomeremailupdateComponent), data: {permission: true}},
      ],
      canActivate: [],
    },
    {
      path: '',
      children: [
        { path: 'imageview/:id', component: ImageviewComponent },
        { path: 'emailtoticketimageurl/:id', component: EmailtoticketimageurlComponent }
      ]
    },
    {
      path: 'customer',
      children: [{ path: 'login', component: LoginComponent }, { path: 'register', component: CustomerRegisterComponent }],
      canActivate: [CustomerAuthGuardGuard],
    },
    {
      path: 'admin',
      component: AdminLayoutComponent,
      children: admin,
      canActivate: [UserGuard],
    },
    {
      path: '',
      component: ErrorLayoutComponent,
      children: errorroute,
    },
    {
      path: '',
      component: CustomerLayoutComponent,
      children: customer,
      canActivate: [CustomerAuthGuardGuard],
    },
    {
      path : 'customer/ticket-view/:id',
      loadComponent:()=>import('./components/customer/ticket-view/ticket-view.component').then(e =>e.TicketViewComponent), 
      data: {
          permission: true
      },
      canActivate: [CustomerAuthGuardGuard],
    },
    {
      path: '**',
      component: PageNotFoundComponent,
    },
  ];