import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CaptchaService } from '../../../../shared/services/admin/captcha.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { CommonModule } from '@angular/common';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';
import { SharedModule } from '../../../../shared/shared.module';

@Component({
  selector: 'app-admin-login',
  templateUrl: './admin-login.component.html',
  styleUrls: ['./admin-login.component.scss'],
  standalone : true,
  imports: [CommonModule,  NgbAlertModule, RouterLink, TranslatePipes, FormsModule, RecaptchaModule, RecaptchaV3Module, AnnouncementHolidayBannerComponent, SharedModule],
  providers : [TranslatePipes]
})
export class AdminLoginComponent extends Unsub implements OnInit {
  @ViewChild('password') password!: ElementRef;
  event;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private AdminService: AdminService,
    private toaster: ToastrService,
    private router: Router,
    private activatedRoute: ActivatedRoute,
    private cookieService: CookieService,
    private translate: TranslatePipe,
    loaderService: LoaderService,
    private captchService : CaptchaService,
    private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }
  data;
  captchaStatus: boolean =false;
  captcha: any;
  returnUrl!: string;
  ngOnInit(): void {
    this.returnUrl =
      this.activatedRoute.snapshot.queryParams['returnUrl'] ||
      '/admin/dashboard';
      this.loaderService.showLoader();
    this.AdminService.getlogin().subscribe({
      next: (res) => {
        this.data = res; 
        if (res) {
          res.announcement?.forEach(alert => {
            const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
            if (hideAlertsUntil) {
              this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
            }
          })
          res.announcements?.forEach(alert => {
            const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
            if (hideAlertsUntil) {
              this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
            }
          })
          res.holidays?.forEach(alert => {
            const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
            if (hideAlertsUntil) {
              this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
            }
          })
        }
        this.loaderService.hideLoader();
      },
      error : ()=> this.loaderService.hideLoader()
    });
  }
  AdminLogin(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      
      if (this.data?.setting?.original?.CAPTCHATYPE=='manual' && this.data?.setting?.original?.RECAPTCH_ENABLE_ADMIN_LOGIN == 'yes') {
        if (!this.captchaStatus) {
          this.toaster.error(this.translate.transform('Captcha Invalid'));
          this.sendingResponse[buttonId] = false;
          return;
        }
      }
      if (this.captchaStatus) {
        data['captcha'] = 'valid';
      }
      this.AdminService.AdminLogin(data).subscribe({
          next: (res) => {
            if (res?.success) {
              localStorage.setItem('user', JSON.stringify(res?.user));
              localStorage.setItem('permissions', JSON.stringify(res.permissions));

              this.toaster.success(this.translate.transform(res.success));
              this.router.navigate([this.returnUrl]).then(() => {
                ngForm.reset();
              });
            }
            ngForm.value.password = "";

            this.sendingResponse[buttonId] = false;
            this.captchService.setCaptchaStatus(false);
          },
          error: (err) => {
            ngForm.value.password = "";
            this.password.nativeElement.value = "";
                   this.sendingResponse[buttonId] = false;
             this.captchService.setCaptchaStatus(false);
          },
          
        });
    }
  }
  public resolved(captchaResponse: string): void {
    this.captcha = captchaResponse;
  }
  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if(!value?.optional){
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if(value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      }else{
        this.captchaStatus = false;
      }
    }
  }

}
