import { Routes } from "@angular/router";

export const Appsettings: Routes = [
  {
    path: "general-setting", loadComponent: () => import('./general-setting/general-setting.component').then(e => e.GeneralSettingComponent), data: {
      permission: 'General Setting Access'
    }
  },
  {
    path: "ticket-setting", loadComponent: () => import('./ticket-setting/ticket-setting.component').then(e => e.TicketSettingComponent), data: {
      permission: 'Ticket Setting Access'
    }
  },
  {
    path: "seo", loadComponent: () => import('./seo/seo.component').then(e => e.SEOComponent), data: {
      permission: 'SEO Access'
    }
  },
  {
    path: "google-analytics", loadComponent: () => import('./google-analytics/google-analytics.component').then(e => e.GoogleAnalyticsComponent), data: {
      permission: 'Google Analytics Access'
    }
  },
  {
    path: "custom-css-js", loadComponent: () => import('./custom-css-js/custom-css-js.component').then(e => e.CustomCssJsComponent), data: {
      permission: 'Custom JS & CSS Access'
    }
  },
  {
    path: "captcha-setting", loadComponent: () => import('./captcha-setting/captcha-setting.component').then(e => e.CaptchaSettingComponent), data: {
      permission: 'Captcha Setting Access'
    }
  },
  {
    path: "social-logins", loadComponent: () => import('./social-logins/social-logins.component').then(e => e.SocialLoginsComponent), data: {
      permission: 'Social Logins Access'
    }
  },
  {
    path: "email-setting", loadComponent: () => import('./email-setting/email-setting.component').then(e => e.EmailSettingComponent), data: {
      permission: 'Email Setting Access'
    }
  },
  {
    path: "external-chat", loadComponent: () => import('./external-chat/external-chat.component').then(e => e.ExternalChatComponent), data: {
      permission: 'Custom Chat Access'
    }
  },
  {
    path: "ip-list", loadComponent: () => import('./ip-list/ip-list.component').then(e => e.IpListComponent), data: {
      permission: 'IpBlock Access'
    }
  },
  {
    path: "botresponsetting", loadComponent: () => import('./botresponse-settings/botresponse-settings.component').then(e => e.BotresponseSettingsComponent), data: {
      permission: "Bot Response Setting Access"
    }
  },
  {
    path: "twiliosetting", loadComponent: () => import('./twiliosetting/twiliosetting.component').then(e => e.TwiliosettingComponent), data: {
      permission: "Twilio Setting Access"
    }
  },
  {
    path: "smstemplateedit/:id", loadComponent: () => import('./smstemplateedit/smstemplateedit.component').then(e => e.SmstemplateeditComponent), data: {
      permission: true
    }
  },
  {
    path: "security-setting", loadComponent: () => import('./security-setting/security-setting.component').then(e => e.SecuritySettingComponent), data: {
      permission: 'Security Setting Access'
    }
  },
  {
    path: "payment-gateways", loadComponent: () => import('./payments-gateways/payments-gateways.component').then(e => e.PaymentsGatewaysComponent), data: {
      permission: 'Payment Gateways Access'
    }
  },
  {
    path: "ai-setup", loadComponent: () => import('./ai-setup/ai-setup.component').then(e => e.AiSetupComponent), data: {
      permission: 'AI Setup Access'
    }
  }
];
