import { ToastrService } from 'ngx-toastr';
import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import Swal from 'sweetalert2';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-captcha-setting',
  templateUrl: './captcha-setting.component.html',
  styleUrls: ['./captcha-setting.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class CaptchaSettingComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  oldvalue
  constructor(
    public adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe, loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  public responce: any;
  public googleCaptcha: any = true;
  ngOnInit(): void {
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.captcha();
      },
    });
    this.captcha();
  }
  captcha() {
    this.loaderService.showLoader();
    this.adminService.captcha().subscribe({
      next: (res) => {
        this.responce = res;
        this.oldvalue = res?.CAPTCHATYPE;
        this.googleCaptcha = res.CAPTCHATYPE == 'off' || res.CAPTCHATYPE == 'manual' ? false : true;
            this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  }
  captchaEnableDisable(event, manual?, google?) {
    this.googleCaptcha =
      event.value == 'off' || event.value == 'manual' ? false : true;
      const PostData = {
        captchatype: event.value,
      };
      if(event.value == 'off' && this.responce.DosEnabledCaptcha){
        Swal.fire({
          icon: 'warning',
          title: this.translate.transform('Are you sure ?'),
          text: this.translate.transform('If you Disable Captcha DOS type will change to IP Block.'),
          showCancelButton: true,
          confirmButtonColor: '#6259ca',
          cancelButtonColor: '#f11541',
          confirmButtonText: this.translate.transform('Disable the captcha!'),
          cancelButtonText: this.translate.transform('Close'),
          reverseButtons: true,
        }).then((result: any) => {
          if (result.isConfirmed) {
            this.adminService.captchatypestore(PostData).subscribe({
              next: (res) => {
                this.toastr.success(this.translate.transform(res.success));
                this.oldvalue = event.value;
              }
            });
          }else{
            if(this.oldvalue == 'manual' ){
              manual.checked = true
              manual.check = true
            }
            if(this.oldvalue == 'google' ){
              google.checked = true
              google.check = true
            }
          }
        });
      }
    else{
      this.adminService.captchatypestore(PostData).subscribe({
        next: (res) => {
          this.toastr.success(this.translate.transform(res.success));
          this.oldvalue = event.value;
        }
      });
    }
  }

  GoogleReCaptchaSetting(data: any, buttonId) {
    const PostData = {

      googlerecaptchakey: data.googlerecaptchakey,
      googlerecaptchasecret: data.googlerecaptchasecret,
    };

    this.sendingResponse[buttonId] = true;
    this.adminService
      .captchastore(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          this.toastr.success(this.translate.transform(res.success));
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      });
  }

  ContactForm(ele) {
    const PostData = {

      RECAPTCH_ENABLE_CONTACT: ele.target.checked == true ? 'yes' : 'no',
    };
    this.adminService.CaptchaContactForm(PostData).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    });
  }

  RegisterForm(ele) {
    const PostData = {

      RECAPTCH_ENABLE_REGISTER: ele.target.checked == true ? 'yes' : 'no',
    };
    this.adminService.captcharegister(PostData).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    });
  }

  LoginForm(ele) {
    const PostData = {
      RECAPTCH_ENABLE_LOGIN: ele.target.checked == true ? 'yes' : 'no',
    };
    this.adminService.captchalogin(PostData).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    });
  }

  GuestTicket(ele) {
    const PostData = {
      RECAPTCH_ENABLE_GUEST: ele.target.checked == true ? 'yes' : 'no',
    };
    this.adminService.captchaguest(PostData).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    });
  }

  AdminLoginForm(ele) {
    const PostData = {
      RECAPTCH_ENABLE_ADMIN_LOGIN: ele.target.checked == true ? 'yes' : 'no',
    };
    this.adminService.captchaadminlogin(PostData).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    });
  }
}
