import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-custom-css-js',
  templateUrl: './custom-css-js.component.html',
  styleUrls: ['./custom-css-js.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class CustomCssJsComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService

  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  public response: any;
  ngOnInit(): void {
    this.settingInprogress();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.settingInprogress();
      },
    });
  }

  settingInprogress() {
    this.loaderService.showLoader();
    this.adminService.customcssjssetting().subscribe({
      next: (res) => {
        this.response = res;
        this.loaderService.hideLoader()
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  ChangeTheValues(data: any, buttonId) {
    const PostData = {

      customcss: data.customcss,
      customjs: data.customjs,
    };
    this.sendingResponse[buttonId] = true;

    this.adminService
      .customcssjs(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          this.toastr.success(this.translate.transform(res.success));
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      });
  }
}
