import { Component, ElementRef, OnInit, QueryList, ViewChildren } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgbNavModule } from '@ng-bootstrap/ng-bootstrap';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-security-setting',
  templateUrl: './security-setting.component.html',
  styleUrls: ['./security-setting.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgbNavModule, NgSelectModule, FormsModule]
})
export class SecuritySettingComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  public responce: any;
  public ForntEndCountriesList: any;
  public AdminCountryBlockList: any;
  constructor(
    public adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.loaderService.showLoader();
    this.adminService
      .securitysetting()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.responce = res;
          
          this.domainList = this.responce?.EMAILDOMAIN_LIST.includes(',') ? this.responce?.EMAILDOMAIN_LIST?.split(',').map(e => e?.trim()).filter(e => e != null || e != undefined) : this.responce?.EMAILDOMAIN_LIST?.length ? [this.responce?.EMAILDOMAIN_LIST] : [];
          this.ForntEndCountriesList = res.COUNTRY_LIST.length ? res.COUNTRY_LIST?.split(',') : null;
          this.AdminCountryBlockList = res.ADMIN_COUNTRY_LIST.length ? res.ADMIN_COUNTRY_LIST?.split(',') : null;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  ngOnInit(): void { }

  public active3 = 1;

  FrontEnd(data: any, buttonId) {
    if (data.valid) {
      const PostData = {
        countrylist: data.value.countrylist.length ? data.value.countrylist : null,
        countryblock: data.value.countryblock,
      };

      this.sendingResponse[buttonId] = true;
      this.adminService
        .securitysettingstore(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.toastr.success(this.translate.transform(res.success));
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  AdminCountryBlock(data: any, buttonId) {
    if (data.valid) {
      const PostData = {

        admincountrylist: data.value.countrylist,
        admincountryblock: data.value.admincountryblock,
      };

      this.sendingResponse[buttonId] = true;
      this.adminService
        .adminsecuritysetting(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  DOSAttackSetting(data: any, buttonId) {
    if (data.valid) {

      const PostData = {
        "dosswitch": data.value.dosswitch,
        "ip_max_attempt": data.value.ip_max_attempt,
        "ip_seconds": data.value.ip_seconds,
        "ipblocktype": data.value.ipblocktype,
      };
      this.sendingResponse[buttonId] = true;

      this.adminService
        .securitysettingIP(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  DomainLists(data: any, buttonId) {

    if (data.valid) {
      const PostData = {

        emaildomain: data.value.emaildomain.join(),
        emaildomainblock: data.value.emaildomainblock,
      };
      this.sendingResponse[buttonId] = true;
      this.adminService
        .emaildomain(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  addOnBlur = true;
  domainList: any[] = [];


  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if (this.filterInput?.first) {
        this.filterInput.first.nativeElement.focus()
      }
    })
  }

  addTagFn(name: any) {
    return name;
  }
}
