import { ToastrService } from 'ngx-toastr';
import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgbNavModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-social-logins',
  templateUrl: './social-logins.component.html',
  styleUrls: ['./social-logins.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgbNavModule, FormsModule]
})
export class SocialLoginsComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  href;
  base;
  constructor(
    public adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  public Response: any;
  ngOnInit(): void {
    this.scocialLogins();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.scocialLogins();
      },
    });
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');
  }

  scocialLogins() {
    this.loaderService.showLoader();
    this.adminService.sociallogin().pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        this.Response = res[0];
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  public active3 = 1;

  EnvatoSettings(data: any, buttonId) {
    if (data.valid) {
      this.sendingResponse[buttonId] = true;
      const PostData = {
        "envato_client_id": data.value.envato_client_id,
        "envato_secret_id": data.value.envato_secret_id,

        "google_client_id": this.Response.google_client_id,
        "google_secret_id": this.Response.google_secret_id,
        "google_status": this.Response.google_status,
      };
      if (data.value.envato_status == true) {
        PostData['envato_status'] = 'enable';
      }

      this.adminService
        .socialloginupdate(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  GoogleSettings(data: any, buttonId) {
    if (data.valid) {
      this.sendingResponse[buttonId] = true;
      const PostData = {
        "google_client_id": data.value.google_client_id,
        "google_secret_id": data.value.google_secret_id,

        "envato_client_id": this.Response.envato_client_id,
        "envato_secret_id": this.Response.envato_secret_id,
        "envato_status": this.Response.envato_status,
      };
      if (data.value.google_status == true) {
        PostData['google_status'] = 'enable';
      }

      this.adminService
        .socialloginupdate(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  microSoftSettings(data: any, buttonId) {
    if (data.valid) {
      this.sendingResponse[buttonId] = true;
      const PostData = {
        "microsoft_app_id": data.value.microsoft_app_id,
        "microsoft_secret_id": data.value.microsoft_secret_id,

        "google_client_id": this.Response.google_client_id,
        "google_secret_id": this.Response.google_secret_id,
        "google_status": this.Response.google_status,

        "envato_client_id": this.Response.envato_client_id,
        "envato_secret_id": this.Response.envato_secret_id,
        "envato_status": this.Response.envato_status,
      };
      if (data.value.microsoft_status == true) {
        PostData['microsoft_status'] = 'enable';
      }

      this.adminService
        .socialloginupdate(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

}
