import { Component, ViewChild } from '@angular/core';
import { FormGroup, ReactiveFormsModule } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, takeUntil, tap } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TextInputComponent } from '../../../../core/components/input/text-input/text-input.component';
import { CheckBoxInputComponent } from '../../../../core/components/input/check-box-input/check-box-input.component';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { SelectionModel } from '@angular/cdk/collections';
import { TranslationService } from '../../../../shared/services/translation.service';
import { CommonModule } from '@angular/common';
import { RouterLink } from '@angular/router';
import { NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-twiliosetting',
  standalone: true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, RouterLink, TextInputComponent, CheckBoxInputComponent, ReactiveFormsModule ],
  templateUrl: './twiliosetting.component.html',
  styleUrl: './twiliosetting.component.scss'
})
export class TwiliosettingComponent extends Unsub {
  setting;
  data;
  

  private searchTerms = new Subject<string>();
  displayedColumns: string[] = ['sno', 'title', 'lastupdatedon', 'actions'];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  isloader = true;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;
  permission: any;
  emailtemplates: any;

  constructor(private adminService: AdminService, private toastr: ToastrService, private translate : TranslatePipe, 
    private translationService: TranslationService, loaderService: LoaderService){
    super(loaderService);
    this.twilioResponseFn();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        this.twilioResponseFn();
      },
    });

    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }
  twilioResponseFn() {
    this.loaderService.showLoader();
    // this.isloader = true;
    this.adminService.twiliosetting()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.setting = res.settings;
          this.permission = res.permissions;
          
          this.emailtemplates = res.queryList;
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(this.emailtemplates.data);

          if (this.dataSource) {
            this.paginator.pageSize = this.emailtemplates.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.emailtemplates.current_page - 1;
              this.paginator.length = this.emailtemplates.total;
            });
            this.dataSource.paginator = this.paginator;
            
            // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
            this.dataSource.sort = this.sort;
            this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
              switch (sortHeaderId) {
                case 'user' || 'ticketdetails' || 'status':
                  return this.nestedProperty(data, sortHeaderId);
                default:
                  return this.nestedCaseInsensitive(data, sortHeaderId);
              }
            }
          }
          this.loaderService.hideLoader();
        }
      })
  }

  twilio = new FormGroup({});
  twilioSettings(name, main){
    if (name.valid) {
      let formData = new FormData();
      for (const key in name.value) {
        if (name.value.hasOwnProperty(key) && !this.twilio[key]) {
          formData.append(key, name.value[key]);
        }
        if(this.twilio[key]){
          formData.append(key, this.twilio[key])
        }
      }
      this.adminService[main](formData).subscribe({
        next: res => {
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        }
      })
    }
  }



  
  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.emailtemplates(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
