import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Subscription } from 'rxjs';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { FormsModule, NgForm } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-sub-category',
  templateUrl: './sub-category.component.html',
  styleUrls: ['./sub-category.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, FormsModule, NgSelectModule]
})
export class SubCategoryComponent extends Unsub implements OnInit {
  public allcategories: any;
  private searchTerms = new Subject<string>();
  public category: any;
  public allcategories$!: Subscription;
  public parentId: any = [];
  public sendingResponse: { [key: string]: boolean } = {};

  public ticketDetails: any;
  public userDetails: any;

  displayedColumns: string[] = [
    'sno',
    'select',
    'subcategoryname',
    'parentCategorylist',
    'status',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  permission: any;
  isloader = true;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.subcategories();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.subcategories();
      },
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  subcategories() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.allcategories$ = this.adminService
      .subcategories(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.allcategories = res.subcategory;
          this.category = res.category;
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(this.allcategories.data);

          if (this.dataSource) {
            this.paginator.pageSize = this.allcategories.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.allcategories.current_page - 1;
              this.paginator.length = this.allcategories.total;
            });
            this.dataSource.paginator = this.paginator;

            // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
            this.dataSource.sort = this.sort;
            this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
              switch (sortHeaderId) {
                case 'user':
                case 'ticketdetails':
                case 'status':
                  return this.nestedProperty(data, sortHeaderId);
                default:
                  return this.nestedCaseInsensitive(data, sortHeaderId);
              }
            }
          }
          if (!this.permission?.includes('Subcategory Delete')) {
            this.displayedColumns = [
              'sno',
              'subcategoryname',
              'parentCategorylist',
              'status',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        }
      });
  }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }
  deleteCategories(row: any, buttonId) {
    const data = {

      id: row?.id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .subcategoryDelete(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  createCategoryModel(createCategory) {
    this.adminService
      .totalcategorylist()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.allcategories = res.categories;
          const modalRef = this.modalService.open(createCategory,
            {
              size: 'lg',
              backdrop: 'static', keyboard: false
            });
          modalRef.result.then(
            () => {
              this.parentId = [];
            },
            () => {
              this.parentId = [];
            }
          );
        },
      });
  }
  editCategoriesDetails(editCategory, row) {
    row?.subcategorylist.forEach((category: any) => {
      if (category) {
        this.parentId.push(category.category_id);
      }
    });
    this.newCategory = {
      "id": row?.id,
      "subcategoryname": row?.subcategoryname,
      "display": row?.display,
      "parentId": this.parentId,
      "status": row?.status,
    };
    this.adminService
      .totalcategorylist()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.allcategories = res.categories;
          const modalRef = this.modalService.open(editCategory, {
            size: 'lg',
          });
          modalRef.result.then(
            () => {
              this.parentId = [];
              this.newCategory = {
                id: '',
                subcategoryname: '',
                display: '',
                parentId: this.parentId,
                status: '',
              };
            },
            () => {
              this.parentId = [];
              this.newCategory = {
                id: '',
                subcategoryname: '',
                display: '',
                parentId: this.parentId,
                status: '',
              };
            }
          );
        },
      });
  }
  newCategory = {
    id: '',
    subcategoryname: '',
    display: '',
    parentId: '',
    status: '',
  };
  subcategoryCreate(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "subcategoryname": ngForm.value.subcategoryname,
        "parent_id": ngForm.value.parent_id,
        "status": ngForm.value.status,
      };

      this.adminService
        .subcategoriesPost(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
            }

            // for (const i in res.errors) {
            //   this.toastr.error(this.translate.transform(res.errors[i][0]));
            // }
            // Check if there are any errors
            if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }

          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  subcategoryEdit(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "subcategory_id": ngForm.value.subcategory_id,
        "subcategoryname": ngForm.value.subcategoryname,
        "parent_id": ngForm.value.parent_id,
        "status": ngForm.value.status,
      };

      this.adminService
        .subcategoriesPost(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
            }
            // Check if there are any errors
            if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }

          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  categorycategoriesStatusChange(row) {
    const val = row?.status != '1' ? '1' : '0';

    const data = {

      id: row?.id,
      status: val,
    };

    this.adminService
      .subcategoryStatus(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        }
      });
  }
  massDeleteCategory(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Category'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .subcategoryDeleteAll(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.subcategories(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.subcategory.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.subcategory.current_page - 1;
          this.paginator.length = data.subcategory.total;
          this.paginator.pageSize = data.subcategory.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
