import { Router } from '@angular/router';
import {
  Component,
  ElementRef,
  OnInit,
  ViewChild,
  ViewChildren,
} from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../shared/class/unsub.class';
import { adminToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { ImageUploadComponent } from '../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../shared/directives/max-length-validator.directive';
import { MinLengthValidatorDirective } from '../../../shared/directives/min-length-validator.directive';

@Component({
  selector: 'app-create-ticket',
  templateUrl: './create-ticket.component.html',
  styleUrls: ['./create-ticket.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule, NgbModule, AngularEditorModule, ImageUploadComponent, MaxLengthValidatorDirective, MinLengthValidatorDirective],
  providers : [TranslatePipes]
})
export class CreateTicketComponent extends Unsub implements OnInit {
  @ViewChild('supportexpired') supportexpired!: ElementRef;
  @ViewChild('verifysupportexpired') verifysupportexpired!: ElementRef;
  @ViewChildren('custo') custo!: ElementRef;
  responseCreateTicket: any;
  envatoName;
  options  = {
    safeMode: false,
    spellcheck: true,
    "showCharsCounter": false,
    "showWordsCounter": false,
    "showXPathInStatusbar": false,
    "buttons": "bold,italic,underline,strikethrough,|,ul,ol,|,font,fontsize,paragraph,|,image,hr,table,link,|,indent,outdent,left,undo,eraser,source"
  }
  priorityList: any[] = [
    { id: 1, name: 'Low' },
    { id: 2, name: 'Medium' },
    { id: 3, name: 'High' },
    { id: 4, name: 'Critical' },
  ];
  form: FormGroup;
  featureimage: any[] = [];
  ticketName: any[] = [];
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  setting;
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private router: Router,
    public fb: FormBuilder,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.ticketData = localStorage.getItem('admincreateTicket') ?? '';
    this.createTicketDetails();

    this.form = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }
  createTicketDetails = () => {

    this.loaderService.showLoader();
    this.adminService.getCreateTicket().subscribe({
      next: (res) => {
        this.responseCreateTicket = res;
        this.setting = res.setting?.original;
        if (res?.customfields) {
          res.customfields.forEach((element) => {
            if (
              (element.fieldtypes == 'radio' ||
                element.fieldtypes == 'checkbox') && element.status == 1
            ) {
              this.customfield['custom_' + element.id] = {
                status: element.fieldrequired,
              };
              if (element.fieldrequired == 1) {
                this.checkStatus = true;
              }
            }
          });
        }
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  };
  ngOnInit(): void { }

  categoryStatus = false;
  category = [];
  subcategory = '';
  projects = '';
  userDetails;
  haspurchasecode = [];
  hassubcategoriess = [];
  hasproject = [];
  envatoId;
  categorychange(id) {
    this.subcategory = '';
    this.projects = '';
    this.licencekey = '';
    this.licencesupport = '';
    this.envatoName = '';
    this.categoryStatus = true;
    const data = {
      "cat_id": id,
    };
    this.adminService.getCatagoryData(data).subscribe({
      next: (res) => {
        this.categoryStatus = false;
        if (res.ENVATO_ON == 'on') {
          this.haspurchasecode = res.envatosuccess;
        }
        this.hasproject = res.projects;
        this.hassubcategoriess = res.subcategories;
      },
    });
  }
  licencekey;
  licencekeyStatus = false;
  licencesupport = null;
  envatoVerify(event, buttonId) {

    this.sendingResponse[buttonId] = true;
    if (event.value?.trim().length == 36) {
      this.envatoId = event.value.trim();
      const data = {
        data: event.value,
      };
      this.adminService.envatoverify(data).subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.valid != 'true') {
            if (this.responseCreateTicket?.setting?.original?.ENVATO_EXPIRED_BLOCK == 'on') {
              this.toastr.error(this.translate.transform(res.message));
              this.supportexpired?.nativeElement.classList.remove('d-none');
              this.verifysupportexpired?.nativeElement.classList.add('d-none');
            }
            if (this.responseCreateTicket?.setting?.original?.ENVATO_EXPIRED_BLOCK == 'off') {
              this.supportexpired?.nativeElement.classList.remove('d-none');
              this.verifysupportexpired?.nativeElement.classList.add('d-none');

              this.toastr.warning(this.translate.transform(res.message));
              this.licencekey = res.key;
              this.envatoName = res.name;
              this.licencekeyStatus = true;
              this.licencesupport = res.valid;
            }
          }
          if (res?.valid == 'true') {
            this.toastr.success(this.translate.transform(res.message));
            this.envatoName = res.name;
            this.licencekey = res.key;
            this.licencekeyStatus = true;
            this.licencesupport = res.valid;
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
    }
  }

  ticketCreate(ngform: NgForm, buttonId) {
    const cf = this.customfield;
    const newCf = {};
    for (const i in cf) {
      const e = cf[i].val;
      newCf[i] = e;
    }    
    if (
      this.haspurchasecode.length
        ? this.licencekeyStatus && ngform.valid && !this.checkStatus && !this.categoryStatus
        : ngform.valid && !this.checkStatus && !this.categoryStatus
    ) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();

      // Append ngform values if they are present and not 'envato_id'
      for (const key of Object.keys(ngform.value)) {
        const val = ngform.value[key];
        if (key !== 'envato_id' && val !== null && val !== undefined && val !== '') {
          formData.append(key, val);
        }
      }
      
      // Append newCf values if present
      for (const key of Object.keys(newCf)) {
        const val = newCf[key];
        if (val !== null && val !== undefined && val !== '') {
          formData.append(key, val);
        }
      }
      
      // Append other values conditionally
      if (this.ticketData) {
        formData.append('message', this.ticketData);
      }
      if (this.licencekey) {
        formData.append('envato_id', this.licencekey);
      }
      if (this.envatoName) {
        formData.append('productname', this.envatoName);
      }
      if (this.licencesupport) {
        formData.append('envato_support', this.licencesupport);
      }
      
      // Append ticketName array values conditionally
      if (Array.isArray(this.ticketName)) {
        for (let i = 0; i < this.ticketName.length; i++) {
          if (this.ticketName[i]) {
            formData.append('ticket[]', this.ticketName[i]);
          }
        }
      }
      this.adminService
        .createTicket(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res && res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/ticket-view/'+ res.ticket_id]);
              localStorage.removeItem('admincreateTicket');
            }
            if (res && res.error?.message) {
              this.toastr.error(this.translate.transform(res.error.message));
            }
            else if (res && res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }


  customfield = {};
  checkStatus = false;
  checkCount: any[] = [];
  customfieldSection(res, name, type): void {
    this.checkStatus = true;
    this.checkCount = [];
    if (type == 'radio') {
      this.customfield[name].val = res;
    }
    if (type == 'checkbox') {
      if (this.customfield[name].val?.includes(res)) {
        this.customfield[name].val = this.customfield[name].val.filter((x) => {
          return x != res;
        });
      } else {
        if (this.customfield[name].val) {
          this.customfield[name].val.push(res);
        } else {
          this.customfield[name].val = [res];
        }
      }
    }
    for (const i in this.customfield) {
      if (this.customfield[i].status == 1) {
        if (this.customfield[i]?.val?.length) {
          continue;
        } else {
          this.checkCount.push(this.customfield[i]);
        }
      }
    }
    if (this.checkCount.length) {
      this.checkStatus = true;
    } else {
      this.checkStatus = false;
    }
  }
  ticketData: any = "";
  eventToStoreData(value) {
    localStorage.setItem('admincreateTicket', this.ticketData ?? '');
  }

  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }

}
