import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { NgbModal, NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslationService } from '../../../shared/services/translation.service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { NgSelectModule } from '@ng-select/ng-select';
import { FormsModule } from '@angular/forms';
import { MaterialeModules } from '../../../material.module';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-custom-field',
  templateUrl: './custom-field.component.html',
  styleUrls: ['./custom-field.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, NgbModule, FormsModule, MaterialeModules],
  providers: [TranslatePipes]
})
export class CustomFieldComponent extends Unsub implements OnInit {
  public allcustomfield: any;
  private searchTerms = new Subject<string>();
  public customfieldopenId: any;
  public sendingResponse: { [key: string]: boolean } = {};
  refreshToken$: any;
  permission: any;
  isloader = true;
  selectedOpt = 'text';
  fieldOptionList: any[] = [
    'text',
    'email',
    'textarea',
    'select',
    'checkbox',
    'radio',
  ];
  displayedColumns: string[] = [
    'sno',
    'select',
    'fieldname',
    'fieldtype',
    'status',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {
    this.customfieldList();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.customfieldList();

      },
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  customfieldList() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .customfield(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.allcustomfield = res.queryList;
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(this.allcustomfield?.data);

          if (this.dataSource) {
            this.paginator.pageSize = this.allcustomfield.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.allcustomfield.current_page - 1;
              this.paginator.length = this.allcustomfield.total;
            });
            this.dataSource.paginator = this.paginator;

            // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
            this.dataSource.sort = this.sort;
            this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
              switch (sortHeaderId) {
                case 'user' || 'ticketdetails' || 'status':
                  return this.nestedProperty(data, sortHeaderId);
                default:
                  return this.nestedCaseInsensitive(data, sortHeaderId);
              }
            }
          }
          if (!this.permission?.includes('CustomField Delete')) {
            this.displayedColumns = [
              'sno',
              'fieldname',
              'fieldtype',
              'status',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        }
      });
  }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource?.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.dataSource?.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  createCustomfieldModel(createCustomfield) {
    const modalRef = this.modalService.open(createCustomfield);
    modalRef.result.then(
      () => {
        this.selectedOpt = 'text';
      },
      () => {
        this.selectedOpt = 'text';
      }
    );
  }
  editCustomfieldDetails(editCustomfield, row) {
    this.CustomfieldObj = {
      customfieldopenId: row?.id,
      sprukofieldtype: row?.fieldtypes,
      sprukofieldname: row?.fieldnames,
      privacyfields: row?.fieldprivacy,
      requiredfields: row?.fieldrequired,
      optionsfields: row?.fieldoptions,
      display: row?.displaytypes,
      status: row?.status,
    };
    this.selectedOpt = row?.fieldtypes;

    const modalRef = this.modalService.open(editCustomfield);
    modalRef.result.then(
      () => {
        this.CustomfieldObj = {
          customfieldopenId: '',
          sprukofieldtype: '',
          sprukofieldname: '',
          privacyfields: '',
          requiredfields: '',
          optionsfields: '',
          display: '',
          status: '',
        };
        this.selectedOpt = 'text';
      },
      () => {
        this.CustomfieldObj = {
          customfieldopenId: '',
          sprukofieldtype: '',
          sprukofieldname: '',
          privacyfields: '',
          requiredfields: '',
          optionsfields: '',
          display: '',
          status: '',
        };
        this.selectedOpt = 'text';
      }
    );
  }
  CustomfieldObj = {
    customfieldopenId: '',
    sprukofieldtype: '',
    sprukofieldname: '',
    privacyfields: '',
    requiredfields: '',
    optionsfields: '',
    display: '',
    status: '',
  };
  editOrCreateCustomfield(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {

        "customfieldopen_id": ngForm.value.customfieldopen_id,
        "sprukofieldtype": ngForm.value.sprukofieldtype,
        "sprukofieldname": ngForm.value.sprukofieldname,
        "privacyfields": ngForm.value.privacyfields ? 1 : 0,
        "requiredfields": ngForm.value.requiredfields ? 1 : 0,
        "optionsfields": ngForm.value.optionsfields
          ? [...new Set(ngForm.value.optionsfields.split(','))].join(',')
          : null,
        "status": ngForm.value.status ? 1 : 0,
        "display": ngForm.value.display,
      };
      this.adminService
        .createCustomfield(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  deleteCustomfield(row: any, buttonId) {
    const data = {

    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .deleteCustomfield(row?.id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  massDeleteCustomfield(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Custom Field'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .massDeleteCustomfield(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  Customfieldstatus(id, ele) {
    const data = {

      status: ele.checked,
    };
    this.adminService
      .statusCustomfield(id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        }
      });
  }

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.customfield(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList?.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
