import { Routes } from '@angular/router';

export const customers: Routes = [
      {
        path: '', loadComponent: ()=>import('./customers/customers.component').then(e=>e.CustomersComponent), data: {
          permission: true
        }
      },
      {
        path: 'create', loadComponent: ()=>import('./create-customer/create-customer.component').then(e=>e.CreateCustomerComponent), data: {
          permission: 'Customers Access'
        }
      },
      {
        path: 'import-list', loadComponent: ()=>import('./customers-import-list/customers-import-list.component').then(e=>e.CustomersImportListComponent), data: {
          permission: 'Customers Importlist'
        }
      },
      {
        path: 'edit/:id', loadComponent: ()=>import('./customers-edit/customers-edit.component').then(e=>e.CustomersEditComponent), data: {
          permission: 'Customers Edit'
        }
      },
      {
        path: 'tickethistory/:id', loadComponent: ()=>import('./customer-ticket-history/customer-ticket-history.component').then(e=>e.CustomerTicketHistoryComponent), data: {
          permission: 'Ticket Edit'
        }
      },
];
