import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';

@Component({
  selector: 'app-edit-email-template',
  templateUrl: './edit-email-template.component.html',
  styleUrls: ['./edit-email-template.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AngularEditorModule, FormsModule, MaxLengthValidatorDirective
  ]
})
export class EditEmailTemplateComponent extends Unsub implements OnInit {
  template = {
    id: 0,
    code: '',
    title: '',
    subject: '',
    body: '',
    created_at: '',
    updated_at: '',
    variables_used : ''
  };
  id!: number;
  setting;
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  
  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private activeRoute: ActivatedRoute,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params: any) => {
        this.id = params.get('id');
        this.loaderService.showLoader();
        this.adminService
          .getemailtemplatesEdit(this.id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.template = res.template;
              this.setting = res.setting?.original;
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
  }

  emailTemplateSubmit(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        subject: ngForm.value.subject,
        body: ngForm.value.body,
      };
      this.adminService
        .emailtemplatesEdit(this.id, data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/email-template']);
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error.message));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  handleDataFromChild(value: string) {
    this.template['body'] = value;
  }
}
