import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-envato-api-token',
  templateUrl: './envato-api-token.component.html',
  styleUrls: ['./envato-api-token.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class EnvatoApiTokenComponent extends Unsub implements OnInit {
  apidata: any;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private tostr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
  }

  ngOnInit(): void {
    this.loaderService.showLoader();
    this.adminService
      .getenvatoapitoken()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.apidata = res.apidata;
          this.loaderService.hideLoader();
        },
        error : ()=> this.loaderService.hideLoader()
      });
  }

  envatoApiCheck(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
        data['enavto_id'] = this.apidata?.id;

      this.adminService
        .envatoapitoken(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            if (res.success) {
              this.tostr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.tostr.error(this.translate.transform(res.error.errors.message));
            }
            this.sendingResponse[buttonId] = false
          },
          error: () => this.sendingResponse[buttonId] = false
        });
    }
  }
}
