import { Routes } from '@angular/router';

export const globaltickets: Routes = [
  {
    path: "closed-tickets", loadComponent: () => import('./closed-tickets/closed-tickets.component').then(e => e.ClosedTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "over-due-tickets", loadComponent: () => import('./over-due-tickets/over-due-tickets.component').then(e => e.OverDueTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "recent-tickets", loadComponent: () => import('./recent-tickets/recent-tickets.component').then(e => e.RecentTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "recent-tickets/inprogress", loadComponent: () => import('./activeTickets/inprogress/inprogress.component').then(e => e.InprogressComponent), data: {
      permission: true
    }
  },
  {
    path: "recent-tickets/onhold", loadComponent: () => import('./activeTickets/onhold/onhold.component').then(e => e.OnholdComponent), data: {
      permission: true
    }
  },
  {
    path: "recent-tickets/reopen", loadComponent: () => import('./activeTickets/reopen/reopen.component').then(e => e.ReopenComponent), data: {
      permission: true
    }
  },
  {
    path: "recent-tickets/totalAssigned", loadComponent: () => import('./activeTickets/totalAssigned.component/totalAssigned.component').then(e => e.TotalAssignedComponent), data: {
      permission: true
    }
  },
  {
    path: "active-tickets", loadComponent: () => import('./active-tickets/active-tickets.component').then(e => e.ActiveTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "total-tickets", loadComponent: () => import('./total-tickets/total-tickets.component').then(e => e.TotalTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "on-hold-tickets", loadComponent: () => import('./on-hold-tickets/on-hold-tickets.component').then(e => e.OnHoldTicketsComponent), data: {
      permission: true
    }
  },
  {
    path: "assigned-tickets", loadComponent: () => import('./assigned-tickets/assigned-tickets.component').then(e => e.AssignedTicketsComponent), data: {
      permission: true
    }
  },
];