import { Component } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { ImageUploadComponent } from '../../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';

@Component({
  selector: 'app-artical-create',
  templateUrl: './artical-create.component.html',
  styleUrls: ['./artical-create.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule, AngularEditorModule, RouterLink, ImageUploadComponent, MaxLengthValidatorDirective]
})
export class ArticalCreateComponent extends Unsub {
  allcategories: any = [];
  public subcategories: any;
  private form: FormGroup;
  private form2: FormGroup;
  public responseCreateTicket: any;
  public featureimageArr: any[] = [];
  public descriptionText: string | any = "";
  public setting: any;
  public sendingResponse: { [key: string]: boolean } = {};
  articleArr: any[] = [];
  toolbar: AngularEditorConfig = adminToolbar;
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private router: Router,
    public fb: FormBuilder,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
    super(loaderService);
    this.settingInprogress();
    this.adminService.RefreshRquestAdmin$.subscribe({
      next: () => {
        this.settingInprogress();
      },
    });

    this.form = this.fb.group({
      image: null,
    });

    this.form2 = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }
  /**
   * settingInprogress that makes a HTTP GET request to the getcreateArtical() API endpoint through an instance of the adminService class. 
   * The response is then processed in the next callback of the  subscribe method, where the res parameter holds the returned data.
   * The takeUntiloperator is used to unsubscribe from the observable stream to avoid memory leaks, with this.unSubscribe$ as the Observable passed in as an argument.
   */
  settingInprogress = () => {
    this.loaderService.showLoader();
    this.adminService
      .getcreateArtical()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.responseCreateTicket = res.setting?.original;
          this.allcategories = res.category;
          this.setting = res.setting?.original;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  };

  ngOnInit(): void {
    this.descriptionText = localStorage.getItem('admincreateArticle');
  }
  createArticle(ngform: NgForm, buttonId) {
    if (ngform.valid) {
      this.sendingResponse[buttonId] = true;
      const artImg: any[] = [];
      this.article.forEach((e) => {
        artImg.push(e?.name);
      });

      const formData: any = new FormData();

      for (const key of Object.keys(ngform.value)) {
        formData.append(key, ngform.value[key]);
      }
      formData.append('message', this.descriptionText);

      formData.append('tags', ngform.value.tags && ngform.value.tags.length > 1 ? ngform.value.tags.join(',') : ngform.value.tags?.[0]);
      for (let i = 0; i < this.articleArr?.length; i++) {
        formData.append('article[]', this.articleArr[i]);
      }
      for (let i = 0; i < this.featureimageArr?.length; i++) {
        formData.append('featureimage', this.featureimageArr[i]);
      }

      this.adminService
        .createArtical(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              localStorage.removeItem('admincreateArticle');
              this.router.navigate(['/admin/knowledge/articles']);
              ngform.resetForm();
              this.form.reset({});
              this.form2.reset({});
              this.article = [];
              this.tagslist = [];
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  categoryStatus = false;
  subcategory = null;
  hassubcategoriess = [];
  categorychange(id) {
    this.subcategory = null;
    this.categoryStatus = true;
    const data = {
      "cat_id": id,
    };
    this.adminService.getCatagoryData(data).subscribe({
      next: (res) => {
        this.categoryStatus = false;
        this.hassubcategoriess = res.subcategories;
      },
    });
  }
  tagslist: any[] = [];

  featureimage: any[] = [];
  featureimage2: any[] = [];

  article: File[] = [];
  /**
  
  Function handleDataFromChild
  *
  This function is called when data is received from a child component.
  It takes a string value as a parameter and sets it to the descriptionText variable.
  *
  @param value - A string value received from a child component.
  */
  handleDataFromChild(value: string) {
    this.descriptionText = value;
  }

  eventToStoreData(value) {
    localStorage.setItem('admincreateArticle', this.descriptionText);
  }
  onImageUploaded(value) {
    this.featureimageArr = value.ticketName;
  }
  onImageUploaded2(value) {
    this.articleArr = value.ticketName;
  }
}
