import { SelectionModel } from '@angular/cdk/collections';
import { HttpHeaders } from '@angular/common/http';
import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule } from '@angular/forms';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';
import { NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';

import { MaterialeModules } from '../../../../material.module';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { ImageUploadComponent } from '../../../../shared/common/includes/image-upload/image-upload.component';

@Component({
  selector: 'app-feature-box',
  templateUrl: './feature-box.component.html',
  styleUrls: ['./feature-box.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, ImageUploadComponent, FormsModule]
})
export class FeatureBoxComponent extends Unsub implements OnInit {
  basic;
  private searchTerms = new Subject<string>();
  loading = true;
  form: FormGroup;
  public sendingResponse: { [key: string]: boolean } = {};
  form2: FormGroup;
  displayedColumns: string[] = [
    'sno',
    'select',
    'title',
    'subtitle',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  permission: any;
  isloader = true;
  setting;
  refreshToken$;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;
  featureList: any;

  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private modalService: NgbModal,
    public fb: FormBuilder,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.featureBoxRes();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.featureBoxRes();

      },
    });

    this.form = this.fb.group({
      image: null,
    });

    this.form2 = this.fb.group({
      image: null,
    });
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
  }

  ngOnInit(): void {

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }

  featureBoxRes() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.adminService
      .featureBox(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.setting = res.setting?.original;
          this.basic = res.basic;
          this.isloader = false;
          this.featureList = res.queryList;
          this.dataSource = new MatTableDataSource(this.featureList.data);

          if (this.dataSource) {
            this.paginator.pageSize = this.featureList.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.featureList.current_page - 1;
              this.paginator.length = this.featureList.total;
            });
            this.dataSource.paginator = this.paginator;
            
              // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
              this.dataSource.sort = this.sort;
              this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                switch (sortHeaderId) {
                  case 'user' || 'ticketdetails' || 'status':
                    return this.nestedProperty(data, sortHeaderId);
                  default:
                    return this.nestedCaseInsensitive(data, sortHeaderId);
                }
              }
          }
          if (!this.permission?.includes('Feature Box Delete')) {
            this.displayedColumns = ['sno', 'title', 'subtitle', 'actions'];
          } this.loaderService.hideLoader();
          this.loading = false;
        },
        error: () => {
          this.isloader = false; this.loaderService.hideLoader();
          this.loading = false;
        }
      });
  }
  featureSectionUpdate(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {

        id: ngForm.value.id,
        featuretitle: ngForm.value.featuretitle,
        featuresub: ngForm.value.featuresub,
        featurecheck: ngForm.value.featurecheck,
      };
      this.adminService
        .featureBoxFeature(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error.errors.message));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }


  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {

    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }
    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  createModelPopup(content: any) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
    modalRef.result.then(
      () => {
        this.featureBoximgRemoved = [];
        this.ticketName = [];
        this.ticketName2 = [];
        this.form.reset({});
        this.form2.reset({});
      },
      () => {
        this.featureBoximgRemoved = [];
        this.ticketName = [];
        this.ticketName2 = [];
        this.form.reset({});
        this.form2.reset({});
      }
    );
  }
  pagesModel = {
    featureboxId: '',
    title: '',
    subtitle: '',
    featureboxurl: '',
    urlCheckbox: '',
    image: '',
    profileimage: '',
  };
  editModelPopup(content: any, row: any) {
    this.pagesModel.featureboxId = row.id;
    this.pagesModel.title = row.title;
    this.pagesModel.subtitle = row.subtitle;
    this.pagesModel.featureboxurl = row.featureboxurl;
    this.pagesModel.urlCheckbox = row.url_checkbox;
    this.pagesModel.image = row.image;
    this.pagesModel.profileimage = row.profileimage;
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
    modalRef.result.then(
      () => {
        this.featureBoximgRemoved = [];
        this.ticketName = [];
        this.ticketName2 = [];
        this.pagesModel.featureboxId = '';
        this.pagesModel.title = '';
        this.pagesModel.subtitle = '';
        this.pagesModel.featureboxurl = '';
        this.pagesModel.urlCheckbox = '';
        this.pagesModel.image = '';
        this.pagesModel.profileimage = '';
        this.form.reset({});
        this.form2.reset({});
      },
      () => {
        this.featureBoximgRemoved = [];
        this.ticketName = [];
        this.ticketName2 = [];
        this.pagesModel.featureboxId = '';
        this.pagesModel.title = '';
        this.pagesModel.subtitle = '';
        this.pagesModel.featureboxurl = '';
        this.pagesModel.urlCheckbox = '';
        this.pagesModel.image = '';
        this.pagesModel.profileimage = '';
        this.form.reset({});
        this.form2.reset({});
      }
    );
  }

  image(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.form.patchValue({
      image: file,
    });
  }

  addFeature(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('title', ngForm.value?.title);
      formData.append('subtitle', ngForm.value?.subtitle);
      formData.append('featureboxurl', ngForm.value?.featureboxurl);
      if (ngForm.value?.url_checkbox) {
        formData.append('url_checkbox', 'on');
      }
      for (let i = 0; i < this.ticketName?.length; i++) {
        formData.append('image', this.ticketName[i]);
      }

      const httpOptions = {
        headers: new HttpHeaders({
          Accept: 'application/json',
        }),
      };

      this.adminService
        .CreatefeatureBox(formData, httpOptions)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.errors) {
              if (res.errors?.name) {
                this.toastr.error(this.translate.transform(res.errors.name));
              }
              for (let i in res.errors) {
                this.toastr.error(this.translate.transform(res.errors[i]));
              }
            }else if(res?.error){
              this.toastr.error(this.translate.transform(res.error));
            }
            else if (res.success) {
              this.modalService.dismissAll();
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  editFeature(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('featurebox_id', ngForm.value?.featurebox_id);
      formData.append('title', ngForm.value?.title);
      formData.append('subtitle', ngForm.value?.subtitle);
      formData.append('featureboxurl', ngForm.value?.featureboxurl);
      if (ngForm.value?.url_checkbox) {
        formData.append('url_checkbox', 'on');
      }
      for (let i = 0; i < this.ticketName2?.length; i++) {
        formData.append('image', this.ticketName2[i]);
      }
      if (this.featureBoximgRemoved) {
        formData.append('featureBoximgRemoved', this.featureBoximgRemoved);
      }
      const httpOptions = {
        headers: new HttpHeaders({
          Accept: 'application/json',
        }),
      };
      this.adminService
        .CreatefeatureBox(formData, httpOptions)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.errors) {
              if (res.errors?.name) {
                this.toastr.error(this.translate.transform(res.errors.name));
              }
              for (let i in res.errors) {
                this.toastr.error(this.translate.transform(res.errors[i]));
              }
            }else if(res?.error){
              this.toastr.error(this.translate.transform(res.error));
            }
            if (res.success) {
              this.modalService.dismissAll();
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  deleteFeature(row: any, buttonId) {
    const data = {

      id: row?.id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .DeletefeatureBox(row?.id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  massDeleteFeatures(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Feature'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .MassDeletefeatureBox(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }

  ticketName: any[] = [];
  ticketName2: any[] = [];
  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }
  featureBoximgRemoved: any;
  onImageUploaded2(value) {
    this.ticketName2 = value.ticketName;
    if (value.mediaremoveIds) {
      let filteredList = this.featureList.data.filter(e => e.image == value.mediaremoveIds[0]?.image);
      this.featureBoximgRemoved = filteredList?.[0].id;
    }
  }

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.featureBox(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
