import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LanguagesService } from '../../../../shared/services/admin/languages.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
@Component({
  selector: 'app-edit-language',
  templateUrl: './edit-language.component.html',
  styleUrls: ['./edit-language.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class EditLanguageComponent extends Unsub implements OnInit {
  public language: any;
  defaultLang;
  public sendingResponse: { [key: string]: boolean } = {};

  public userId!: any;
  constructor(
    public languagesService: LanguagesService,
    private route: ActivatedRoute,
    private router: Router,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    route.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.userId = params['id'];
        this.loaderService.showLoader();
        this.languagesService
          .editLanguage(this.userId)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (ele) => {
              this.defaultLang = ele.default_lang;
              this.language = ele.language;
              this.loaderService.hideLoader();
            },
            error : ()=> this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void {
  }

  ChangeTheValues(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      // let isdefault;
      // let isrtl;

      const PostData = {
        languagename: ngForm.value.languagename,
        languagenativename: ngForm.value.languagenativename,
      };
      if (ngForm.value.is_default == true) {
        // isdefault = this.userId;

        PostData['is_default'] = ngForm.value.is_default;
      }
      if (ngForm.value.is_rtl == true) {
        PostData['is_rtl'] = 1;
      }

      this.languagesService
        .update(this.userId, PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: () => {
            this.sendingResponse[buttonId] = false;
            this.router.navigate(['/admin/languages']);

          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });

    }
  }
}
