import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LanguagesService } from '../../../../shared/services/admin/languages.service';
import { LoaderService } from '../../../../shared/services/loader.service';

import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-insert-language',
  templateUrl: './insert-language.component.html',
  styleUrls: ['./insert-language.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule]
})
export class InsertLanguageComponent extends Unsub implements OnInit {
  public language: any;
  languagesKey: any;
  transCount: any;
  groups: any;
  active: any;
  isloader = true;
  public sendingResponse: { [key: string]: boolean } = {};
  public userId!: string;
  constructor(
    public languagesService: LanguagesService,
    route: ActivatedRoute,
    private router: Router,
    private toastr: ToastrService,
    private translate: TranslatePipe, loaderService: LoaderService  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    route.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.userId = params['id'];
      },
    });
  }

  ngOnInit(): void {}

  InsertData(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      this.isloader = true;
      const UpdateData = ngForm.value;
      this.languagesService
        .insertLanguage(this.userId, UpdateData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.isloader = false;
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/languages']);
            }
          },
          error: () => {
            this.isloader = false;
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
