import { CommonModule } from '@angular/common';
import { Component, Input } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { RouterLink } from '@angular/router';
import { LiveChatService } from '../../../../../shared/services/admin/livechat.service';
import { LivechatSocketService } from '../../../../../shared/services/livechat-socket.service';

@Component({
  selector: 'app-agent-message',
  standalone: true,
  imports: [CommonModule, FormsModule, RouterLink],
  template: `<li class="chat-item-start">
      <div class="chat-list-inner">
        <div class="chat-user-profile">
            @if(data.sender_image){
                <span class="avatar avatar-md brround" [style.backgroundImage]="'url(uploads/profile/' + data.sender_image + ')'">
                </span>
            }@else{
                <span class="avatar avatar-md brround" style="background-image: url('uploads/profile/user-profile.png')">
                </span>
            }
        </div>
        <div class="ms-3">
            <span class="chatting-user-info">
                {{data.livechat_username?.replace(this.autoUserInfo?.name,'You')}}
                <span class="msg-sent-time">
                    {{this.formatTime(data.created_at)}}
                    @if(data.status == 'seen'){
                        <span class="chat-read-mark align-start d-inline-flex"><i class="ri-check-double-line"></i></span> 
                    }@else{
                        <span class="chat-read-icon align-start d-inline-flex"><i class="ri-check-fill"></i></span>
                    }
                </span>
            </span>
            <div class="main-chat-msg">
                @if(data.message_type == "image"){
                @if(['jpg', 'png', 'jpeg', 'svg'].includes(getFileType(getEncodedMessage(data.message)))){
                    <div (click)="AllFileViewer(data.message)"
                        [attr.imageSrc]="getEncodedMessage(data.message)"
                        class="imageMessageLiveChat"  style=" aspect-ratio: 1; background-repeat: no-repeat; background-color: transparent;background-position: center;background-size: contain;height:15rem"                        
                        [style.background-image]="'url(' + getEncodedMessage(data.message) + ')'">
                    </div>
                }
                @else{
                    <a  [href]="data.message"  download
                        class="uhelp-attach-acion p-2 rounded border lh-1 d-flex align-items-center justify-content-center"
                        download 
                        style="
                        width: 100%;
                        max-height: 55px;
                        border-radius: 5px;
                        height: 65px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        padding: 0.5rem;border:var(--border)">.{{getFileType(data.message)}}
                        <i class="fa fa-download"></i>
                    </a>
                }
                }
                @else{
                <div style="white-space: pre-line;" class="text-start"><p class="mb-0 text-break" >{{data.message}}</p></div>
                }
            </div>
        </div>
          
      </div>
  </li>
  @if(imageUrl){
      <div class="liveChatImageViewer" >
            <span class="liveChatImageClose" (click)="closePreview()">×</span>
            <img class="liveChatImageTag" [src]="imageUrl">
        </div>
  }
`
})
export class AgentMessageComponent {
    @Input('data') data:any;
    @Input('autoUserInfo') autoUserInfo:any;
    formatTime;
    constructor(private LivechatSocketService: LivechatSocketService){
        this.formatTime = this.LivechatSocketService.formatTime;
    }
    imageUrl = null;
    
    AllFileViewer = (res)=>{
        this.imageUrl = res;
    }
    closePreview(){
        this.imageUrl = null;
    }
    downloadFile(res){
    }

    getEncodedMessage(val): string {
        // Split the URL into base URL and filename
        const baseUrl = val.substring(0, val.lastIndexOf('/') + 1);
        const filename = val.substring(val.lastIndexOf('/') + 1);

        // Encode only the filename part
        const encodedFilename = encodeURIComponent(filename);
        // Combine the base URL with the encoded filename
        let url = baseUrl + encodedFilename;
        return "'" + url + "'";
    }
    getFileType(value): string {
        let valueStrip = value.slice(1, value.length -1).split('.');
        let ext = valueStrip[valueStrip.length - 1];  
        return ext?.toLowerCase();
    }
}
