import { Component } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LoaderService } from '../../../../shared/services/loader.service';

@Component({
  selector: 'app-test-it-out',
  standalone: true,
  imports: [],
  templateUrl: './test-it-out.component.html',
  styleUrl: './test-it-out.component.scss'
})
export class TestItOutComponent extends Unsub {
  id;
  href;
  base;
  constructor(private activeRoute: ActivatedRoute, loaderService: LoaderService){
    super(loaderService);
  }
  ngOnInit(): void {
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
    this.loadScripts();
      }
    })
  }

  private loadScripts(): void {
      this.href = location.origin;
      this.base = document.querySelector('base')?.getAttribute('href');
      const scriptElement = document.createElement('script');
      var currentPath = window.location.origin + window['$BaseVal'];
      scriptElement.src = currentPath + '/assets/livechat/liveChat.js';
      scriptElement.setAttribute('domainName', currentPath);
      scriptElement.setAttribute('wsPort', '8443');
      scriptElement.setAttribute('testItOut', this.id);
      scriptElement.onload = () => {};
      document.body.appendChild(scriptElement);
  }
}
