import { Component, OnInit } from '@angular/core';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { ColorPickerModule } from 'ngx-color-picker';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
@Component({
  selector: 'app-compose-employees',
  templateUrl: './compose-employees.component.html',
  styleUrls: ['./compose-employees.component.scss'],
  standalone : true,
  imports: [TranslatePipes, AngularEditorModule, ColorPickerModule, NgSelectModule, FormsModule, RouterLink]
})
export class ComposeEmployeesComponent extends Unsub implements OnInit {
  userslist: any;
  permission;
  color;
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  setting: any;
  message!: string;
  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.loaderService.showLoader();
    this.adminService
      .customnotificationList()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res: any) => {
          this.userslist = res?.users;
          this.permission = res.permissions;
          this.setting = res.setting?.original;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
      this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {

  }

  composeEmployee(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      // const data = {
      //   message: ngForm.value.message,
      //   subject: ngForm.value.subject,
      //   users: ngForm.value.users,
      //   tag: ngForm.value.tag,
      //   selecttagcolor: ngForm.value.selecttagcolor,
      // };
      
      const formData: any = new FormData();
      formData.append('message', ngForm.value.message);
      formData.append('subject', ngForm.value.subject);
      formData.append('users', ngForm.value.users);
      formData.append('selecttagcolor', ngForm.value.selecttagcolor);

      if (ngForm.value?.tag?.length) {
        formData.append('tag', ngForm.value?.tag?.length ? ngForm.value.tag.join(',') : ngForm.value.tag);
      }
      this.adminService
        .employeecompose(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate([
                '/admin/notifications/custom-notifications',
              ]);
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error.errors.message));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  public dynamicLightPrimary(data: any): void {
    this.color = data.color;
  }

  employee = [];
  public onSelectAll() {
    const selected = this.userslist.map(item => item.id);
    this.employee = selected;
  }

  public onClearAll() {
    this.employee = [];
  }

  addTagFn(name: any) {
    return name;
  }

  handleDataFromChild(value: string) {
    this.message = value;
  }
}
