import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule, DatePipe } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TimezonePipe } from '../../../../shared/pipes/timzone.pipe';

@Component({
  selector: 'app-custom-notification-view',
  templateUrl: './custom-notification-view.component.html',
  styleUrls: ['./custom-notification-view.component.scss'],
  standalone : true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, TimezonePipe ],
  providers: [DatePipe]
})
export class CustomNotificationViewComponent extends Unsub implements OnInit {
  notifications;
  setting;
  timezone: any;
  constructor(
    private adminService: AdminService,
    private activedRoute: ActivatedRoute,
    loaderService: LoaderService, 
    private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.activedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.loaderService.showLoader();
        this.adminService
          .notification(params.get('id'))
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.notifications = res.notifications;
              this.setting = res.setting?.original;
              this.timezone = res.timezonedata;
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void { }

  sanitizeHtml(html: string): SafeHtml {
    if(html) return this.sanitizer.bypassSecurityTrustHtml(html);
    return '';
  }
}
