import { Location } from '@angular/common';
import { Component } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-adminemailupdate',
  templateUrl: './adminemailupdate.component.html',
  styleUrls: ['./adminemailupdate.component.scss'],
  standalone: true,
  imports: [TranslatePipes, RouterLink, FormsModule],
  providers: [TranslatePipes]
})
export class AdminemailupdateComponent extends Unsub {
  email = '';
  showmail = true;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(private activatedRoute: ActivatedRoute, private adminService: AdminService, private toastr: ToastrService, private translate: TranslatePipe,
    private router: Router,
    private state: Location,
    loaderService: LoaderService) {
    super(loaderService);
    this.activatedRoute.paramMap.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (params) => {
        this.email = params.get('email') || '';
      },
    });
  }
  updateEmail(ngForm, buttonId) {
    this.sendingResponse[buttonId] = true;
    let data = ngForm.value;
    data.oldemail = this.email;
    this.adminService.adminnewemailstore(data).subscribe({
      next: (res) => {
        if (res.success) {
          this.toastr.success(this.translate.transform(res.success))
          this.showmail = false;
        }
        if (res.error) {
          this.toastr.error(this.translate.transform(res.error))
        }
        this.sendingResponse[buttonId] = false;
      },
      error: err => {
        this.sendingResponse[buttonId] = false;
      }
    })
  }
  checkOtp(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      let data = ngForm.value;
      this.adminService.emailchangeotpverify(this.email, data).subscribe({
        next: (res) => {
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            this.router.navigate(['/admin/login']);
          }
          if (res.error) {
            this.toastr.error(this.translate.transform(res.error))
          }
          this.sendingResponse[buttonId] = false;
        },
        error: err => {
          this.sendingResponse[buttonId] = false;
        }
      })
    }else{
      this.toastr.error(this.translate.transform("OTP is required"))
    }
  }

}
