import { Component, ElementRef, OnInit, QueryList, ViewChild, ViewChildren } from '@angular/core';
import { NgbModal, NgbRatingConfig, NgbRatingModule } from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs';
import { HttpHeaders } from '@angular/common/http';
import { FormGroup, FormBuilder, NgForm, FormsModule } from '@angular/forms';
import { CommonModule, Location } from '@angular/common';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminProfileService } from '../../../shared/services/admin/admin-profile.service';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import moment from 'moment-timezone';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgxMatIntlTelInputComponent } from 'ngx-mat-intl-tel-input';
import Swal from 'sweetalert2';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-profile',
  templateUrl: './profile.component.html',
  styleUrls: ['./profile.component.scss'],
  standalone :  true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, NgbRatingModule, NgSelectModule, NgxMatIntlTelInputComponent, FormsModule],
  providers : [TranslatePipes]
})
export class ProfileComponent extends Unsub implements OnInit {
  @ViewChild('ngsearch') ngsearch: any;
  @ViewChild('twofactorEle', { static: false }) twofactorEle!: ElementRef;
  @ViewChild('emailtwofactorEle', { static: false }) emailtwofactorEle!: ElementRef;
  @ViewChild('TwoFactorAuthentication', { static: false }) TwoFactorAuthentication!: ElementRef;
  @ViewChild('emailtwofac', { static: false }) emailtwofac!: ElementRef;
  @ViewChild('configured', { static: false }) configured!: ElementRef;
  @ViewChild('profileImg') profileImg!: ElementRef;
  timezone;
  timezones;
  reconfigureStatus = true;
  emailtwofactStatus = true;
  workingmodeStatus = true;
  public sendingResponse: { [key: string]: boolean } = {};
  setting;
  form: FormGroup;
  admin;
  adminLang;
  adminSkills;
  public generatePassword: any;
  public AdminID: any;
  public EmailError: any = null;
  public Src: any;
  rating = 0;
  userid: any;
  permission: any;
  countries: any;
  profileRemoved: any;
  constructor(
    private adminProfileService: AdminProfileService,
    private AdminService: AdminService,
    config: NgbRatingConfig,
    private customersService: CustomersService,
    private toastr: ToastrService,
    private router: Router,
    private translate: TranslatePipe,
    public fb: FormBuilder,
    private modalService: NgbModal,
    private sanitizer: DomSanitizer,
    private state: Location,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    config.max = 5;
    config.readonly = true;
    this.form = this.fb.group({
      image: null,
    });
    this.timezones = moment.tz.names();
  }

  ngOnInit(): void {
    this.profile();
    this.AdminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.profile();
      }
    });
  }
  public timeZoneChanged(timeZone: string): void {
    this.timezone = timeZone;
  }


  profile() {
    this.loaderService.showLoader();
    this.adminProfileService
      .index()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele) => {
          this.permission = ele.permissions;
          this.countries = ele.countries;
          this.timezone = ele.users.timezone;
          this.rating = ele.avg;
          this.setting = ele.setting?.original;
          this.admin = ele.users;
          this.adminLang = ele.users.languagues?.split(',');
          this.adminSkills = ele.users.skills?.split(',');
          this.AdminID = this.admin?.id;
          this.Src = this.admin?.profileimage;
            this.loaderService.hideLoader();
        },
        error : ()=> this.loaderService.hideLoader()
      });
  }
  
  autgoogleAuth = {
    QR_Image: "",
    secret: "",
    success: "",
    workprogress: ""
  }
  googletwofactorData = {}
  // Google Two Factor Authentication
  configureAuth(content, configStatus?) {
    let status = this.twofactorEle.nativeElement.checked;
    this.googletwofactorData = {
      "user_id": this.AdminID,
      "emptwofact": status
    }
    if (!configStatus) {
      if(this.setting?.Employe_email_two_fact == 'on' && this.admin?.twofactorauth == 'emailtwofact' && this.emailtwofactStatus){
        Swal.fire({
          icon: 'warning',
          title: this.translate.transform('Are you sure?'),
          text: this.translate.transform('If you want to Enable Google Two Factor Need to disable the Email Two factor Authentication'),
          reverseButtons: true,
        }).then((result: any) => {

        })
        this.twofactorEle.nativeElement.checked = false;      
        return;
      }
      this.reconfigureStatus = true;
    }
     const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
      modalRef.result.then(
        () => {
        },
        (res) => {
          if (!configStatus && res == 'Cross click') {
            this.twofactorEle.nativeElement.checked = !this.twofactorEle.nativeElement.checked;
          }
        }
      )
      return;
  }
  googleTwofactorDisable(ngForm, buttonId){
    let data = this.googletwofactorData;
    data['password'] = ngForm.value.password;

    this.AdminService.emptwofactqr(data).subscribe(res => {
      if (res?.success) {
        this.googletwofactorData = {}; 
        if (res?.workprogress == "notworkingmode") {
          this.toastr.success(res.success);
          this.workingmodeStatus = false;
          this.reconfigureStatus = false;
        }
        else if (res?.workprogress == "workingmode") {
          this.emailtwofactorEle.nativeElement.checked = false;
          this.autgoogleAuth = res;
          this.workingmodeStatus = true;
          this.toastr.success(res.success);
          this.reconfigureStatus = false;
        }
        this.modalService.dismissAll();
      }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
    })
  }
  verifyGoogleAuth(otp) {
    let data = {
      'otp': otp.value,
      'id': this.AdminID,
      'secret_key_value': this.autgoogleAuth.secret
    }
    this.AdminService.empgoogle2faotp(data).subscribe(res => {      
      if (res?.error) {
        this.toastr.error(this.translate.transform('Invalid otp'));
        this.workingmodeStatus = true;
      }
      if (res?.success) {

        this.autgoogleAuth = {
          QR_Image: "",
          secret: "",
          success: "",
          workprogress: ""
        }
        this.toastr.success(this.translate.transform('GoogleTwo factor authentication activated'));
        this.workingmodeStatus = false;
        this.reconfigureStatus = true;
      }
    })
  }
  removeAuth(content) {
    this.googletwofactorData = {
      "user_id": this.AdminID
    }
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
  }
  emailtwofactordata = {};
  // Email Two Factor Authentication
  sprukoemailtwofactor(ele, content) {
    if(this.setting?.Employe_google_two_fact == 'on' && this.admin?.twofactorauth == 'googletwofact' && this.reconfigureStatus){
      Swal.fire({
        icon: 'warning',
        title: this.translate.transform('Are you sure?'),
        text: this.translate.transform('If you want to Enable Email Two Factor Need to disable the Google Two factor Authentication'),
        reverseButtons: true,
      }).then((result: any) => {

      })
      this.emailtwofactorEle.nativeElement.checked = false;      
      return;
    }
    
    this.reconfigureStatus = false;
    this.emailtwofactStatus = true;
    if (this.twofactorEle) {
      this.twofactorEle.nativeElement.checked = false;
    }
    let status = ele.target?.checked;
    this.emailtwofactordata = {
      "cust_id": this.AdminID,
      "emailtwofact": status
    }
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
      },
      (res) => {
        if(res == 'Cross click'){
          this.emailtwofactorEle.nativeElement.checked = !this.emailtwofactorEle.nativeElement.checked;
        }
      }
    )
    return;
  }
  twofactoremail(ngForm, buttonId){
    let data = this.emailtwofactordata;
    data['password'] = ngForm.value.password;
    this.autgoogleAuth = {
      QR_Image: "",
      secret: "",
      success: "",
      workprogress: ""
    }
    this.AdminService.empemail2faotp(data).subscribe(res => {
        this.sendingResponse[buttonId] = false;
        if (res?.success) {
          this.emailtwofactordata = {};      
          this.toastr.success(this.translate.transform(res.success));
          this.modalService.dismissAll();
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
    })
  }
  ariaValueText(current: number, max: number) {
    return `${current} out of ${3} hearts`;
  }

  ChangePassword(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;

      const putData = {
        "current_password": ngForm.value.current_password,
        "password_confirmation": ngForm.value.password_confirmation,
        "password": ngForm.value.password,
      };

      this.adminProfileService
        .changePassword(putData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/login'], {
                queryParams: {
                  returnUrl: this.state.path(),
                },
              });
              this.EmailError = null;
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
              this.EmailError = res.error;
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  openModel(content: any, email: any) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
  }
  adminemailchange(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      data.email = this.admin?.email;
      this.AdminService
        .adminemailchange(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  public NewPassword = 'password';

  eyeClick = () => {
    this.NewPassword = this.NewPassword == 'password' ? 'text' : 'password';
  };

  GeneratePassword() {
    this.generatePassword =
      this.customersService.RandomPassWord();
  }

  SwitchToDarkMode(ele: any) {
    const putData = {
      dark: ele.currentTarget?.checked ? 1 : 0,
      id: this.AdminID,
    };
    this.adminProfileService
      .usersettings(putData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.toastr.success(this.translate.transform(res.success));
        }
      });
  }

  ProfileImageremove(event, ele) {
    this.profileRemoved = this.AdminID;
    event.remove();
    ele.value = '';
    this.form.controls['image'].setValue(null);
  }

  EmailNotificationOnOff(ele: any): void {
    const putData = {

      emailvalue: ele.currentTarget?.checked ? 1 : 0,
      userid: this.AdminID,
    };

    this.adminProfileService
      .emailonoff(putData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.toastr.success(this.translate.transform(res.success));
          this.form.reset({});
        }
      });
  }

  image(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.form.patchValue({
      image: file,
    });
  }

  EditProfile(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('image', this.form.controls['image'].value);
      formData.append('firstname', ngForm.value.firstname);
      formData.append('lastname', ngForm.value.lastname);
      formData.append('profileRemoved', this.profileRemoved);
      formData.append('phone', ngForm.value.phone);
      if (ngForm.value.languages) {
        formData.append('languages', ngForm.value.languages);
      }
      if (ngForm.value.skills) {
        formData.append('skills', ngForm.value.skills);
      }
      formData.append('country', ngForm.value.countrylist);
      formData.append('timezone', ngForm.value.timezone);
      const httpOptions = {
        headers: new HttpHeaders({
          Accept: 'application/json',
        }),
      };

      this.adminProfileService
        .EditProfile(formData, httpOptions)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/profile']);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if (this.filterInput?.first) {
        this.filterInput.first.nativeElement.focus()
      }
    })
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
  
}
