import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { HttpHeaders } from '@angular/common/http';
import { FormGroup, FormBuilder, FormsModule } from '@angular/forms';
import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import Swal from 'sweetalert2';
import { takeUntil } from 'rxjs';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-projects-import',
  templateUrl: './projects-import.component.html',
  styleUrls: ['./projects-import.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class ProjectsImportComponent extends Unsub implements OnInit {
  @ViewChild('uploadFile') uploadFile!: ElementRef;
  public sendingResponse: { [key: string]: boolean } = {};
  myform!: FormGroup;
  form: FormGroup;
  Error = false;
  ErrorMessage: any;
  constructor(
    public fb: FormBuilder,
    private adminService: AdminService,
    private toastr: ToastrService,
    private router: Router,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.form = this.fb.group({
      file: null,
    });
  }

  ngOnInit(): void { }

  File(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.form.patchValue({
      file: file,
    });
  }

  UploadProjects(res: any, buttonId) {
    const formData: any = new FormData();
    formData.append('file', this.form.controls['file'].value);

    const httpOptions = {
      headers: new HttpHeaders({
        Accept: 'application/json',
      }),
    };

    this.sendingResponse[buttonId] = true;

    if (res.value.file.includes('.csv') || res.value.file.includes('.xlsx')) {
      this.adminService
        .uploadProjects(formData, httpOptions)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.Error = false;
            if (res?.success) {
              Swal.fire({
                title: this.translate.transform('Imported Successfully'),
                text: this.translate.transform(res.success),
                icon: 'success',
                confirmButtonColor: '#6259ca',
              });
              this.form.reset({});
              this.router.navigate(['/admin/projects']);
            }
            if (res.error) {
              this.form.reset({});
              this.uploadFile.nativeElement.value = "";
              if(typeof res.error === 'string'){
                this.toastr.error(this.translate.transform(res.error));
              }else if (typeof res.error === 'object') {
                this.Error = true;
                for (const el in res.errors) {
                  this.ErrorMessage = res.errors[el];
                  this.toastr.error(this.translate.transform(res.errors[el]));
                }
              }
            }
          },
          error: () => {
            this.uploadFile.nativeElement.value = "";
            this.form.reset({});
            this.sendingResponse[buttonId] = false;
          },
        });
    } else {
      this.Error = true;
      this.ErrorMessage = this.translate.transform('The File Type Is Not Supported');
      this.sendingResponse[buttonId] = false;
    }
  }
}
