import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';

import {
  ApexNonAxisChartSeries,
  ApexResponsive,
  ApexChart,
  ApexFill,
  ApexDataLabels,
  ApexLegend,
  NgApexchartsModule,
} from 'ng-apexcharts';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { RouterLink } from '@angular/router';
import { NgbRatingModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { CommonModule } from '@angular/common';

export type ChartOptions = {
  series: ApexNonAxisChartSeries;
  chart: ApexChart;
  responsive: ApexResponsive[];
  labels: any;
  fill: ApexFill;
  legend: ApexLegend;
  dataLabels: ApexDataLabels;
};
@Component({
  selector: 'app-reports',
  templateUrl: './reports.component.html',
  styleUrls: ['./reports.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgApexchartsModule, RouterLink, NgbRatingModule, CommonModule]
})
export class ReportsComponent extends Unsub implements OnInit {
  reports;
  setting;
  timezone;
  refreshToken$: any;
  public employeechartOptions: Partial<ChartOptions> | any;
  public customerOptions: Partial<ChartOptions> | any;
  public knowledgeBasechartOptions: Partial<ChartOptions> | any;
  public ticketchartOptions: Partial<ChartOptions> | any;
  public ticketPrioritychartOptions: Partial<ChartOptions> | any;

  constructor(private adminService: AdminService, private translate: TranslatePipe, 
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.employeechartOptions = {
      series: [],
      chart: {
        height: 300,
        type: 'donut',
      },
      noData: {
        text: this.translate.transform('No data to display'),
        align: "center"
      },
      dataLabels: {
        enabled: false,
        position: 'bottom',
      },

      legend: {
        show: false,
        position: 'bottom',
      },
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            show: true,
            position: 'bottom'
          }
        }
      }],
      labels: ['Active', 'Inactive'],
      colors: ['#0dcd94', '#fbc518'],
    };
    this.customerOptions = {
      series: [],
      chart: {
        height: 300,
        type: 'donut',
      },
      noData: {
        text: this.translate.transform('No data to display'),
        align: "center"
      },
      dataLabels: {
        enabled: false,
        position: 'bottom',
      },

      legend: {
        show: false,
      },
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            show: true,
            position: 'bottom'
          }
        }
      }],
      labels: ['Active', 'Inactive'],
      colors: ['#0dcd94', '#fbc518'],
    };
    this.ticketchartOptions = {
      series: [],
      chart: {
        height: 300,
        type: 'donut',
      },
      dataLabels: {
        enabled: false,
        position: 'bottom',
      },
      noData: {
        text: this.translate.transform('No data to display'),
        align: "center"
      },
      legend: {
        show: false,
      },
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            show: true,
            position: 'bottom'
          }
        }
      }],
      labels: ['New', 'Inprogress', 'On-Hold', 'Re-Open', 'Closed'],
      colors: ['#ff6f31', '#128af9', '#fbc518', '#17d1dc', '#f7284a'],
    };
    this.knowledgeBasechartOptions = {
      series: [],
      chart: {
        height: 300,
        type: 'donut',
      },
      noData: {
        text: this.translate.transform('No data to display'),
        align: "center"
      },
      dataLabels: {
        enabled: false,
        position: 'bottom',
      },
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            show: true,
            position: 'bottom'
          }
        }
      }],
      labels: ['Published', 'Unpublished'],
      colors: ['#ff6f31', '#128af9'],
    };
    this.ticketPrioritychartOptions = {
      series: [],
      chart: {
        height: 300,
        type: 'donut',
      },
      noData: {
        text: this.translate.transform('No data to display'),
        align: "center"
      },
      dataLabels: {
        enabled: false,
        position: 'bottom',
      },

      legend: {
        show: false,
      },
      responsive: [{
        breakpoint: 480,
        options: {
          legend: {
            show: true,
            position: 'bottom'
          }
        }
      }],
      labels: ['Low', 'Medium', 'High', 'Critical'],
      colors: ['#3366ff', '#ffad00', '#01c353', '#fe7f00'],
    };
    this.reportFn();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.reportFn();
      }
    });
  }

  ngOnInit(): void {

  }
  reportFn() {
    this.loaderService.showLoader();
    this.adminService.reports().subscribe({
      next: (res) => {
        this.reports = res;
        this.setting = res.setting?.original;
        this.timezone = res.timezonedata;
        this.employeechartOptions.series = [
          this.reports?.agentactivec,
          this.reports?.agentinactive,
        ];
        this.customerOptions.series = [
          this.reports?.customeractive,
          this.reports?.customerinactive,
        ];
        this.ticketchartOptions.series = [
          this.reports?.newticket,
          this.reports?.inprogressticket,
          this.reports?.onholdticket,
          this.reports?.reopenticket,
          this.reports?.closedticket,
        ];
        this.ticketPrioritychartOptions.series = [
          this.reports?.prioritylow,
          this.reports?.prioritymedium,
          this.reports?.priorityhigh,
          this.reports?.prioritycritical,
        ];
        this.knowledgeBasechartOptions.series = [
          this.reports?.articlepublished,
          this.reports?.articleunpublished,
        ];
        this.loaderService.hideLoader();
      },
      error : ()=> this.loaderService.hideLoader()
    });
  }
  ngAfterViewInit() { }
}
