import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { JsonParsePipe } from '../../../shared/pipes/json-parse.pipe';
import { IsArrayPipe } from '../../../shared/pipes/isArray.pipe';
import { DateAgoPipe } from '../../../shared/pipes/date-ago/date-ago.pipe';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
@Component({
  selector: 'app-tickethistory',
  templateUrl: './tickethistory.component.html',
  styleUrls: ['./tickethistory.component.scss'],
  standalone: true,
  imports : [CommonModule, DateAgoPipe, TranslatePipes, NgbTooltipModule, JsonParsePipe, IsArrayPipe, AdminPageHeaderComponent]
})
export class TickethistoryComponent extends Unsub implements OnInit {
  data;
  id;
  timezone;
  constructor(private adminService: AdminService, private activatedRoute: ActivatedRoute, 
    loaderService: LoaderService,  private sanitizer: DomSanitizer) {
      super(loaderService);
    activatedRoute.params.subscribe({
      next: params => {
        this.id = params['id'];
        this.ticketHistory();
      }
    });
  }

  ngOnInit(): void {
  }

  ticketHistory() {
    this.loaderService.showLoader();
    this.adminService.ticketHistory(this.id).subscribe({
      next: res => {
        this.data = res;
        this.timezone = res.timezonedata;
        this.loaderService.hideLoader();
      },
      error : ()=> this.loaderService.hideLoader()
    });
  }
  
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }

  convertToArray(value:string){
    // Handle potential errors and edge cases
  if (!value) {
    return [];
  }

  try {
    // Parse JSON string
    const parsedValue = JSON.parse(value);

    if (!Array.isArray(parsedValue)) {
      throw new Error('Invalid JSON format: not an array');
    }

    return parsedValue;
  } catch (error) {
    console.error('Error parsing JSON:', error);
    return []; // Or handle the error gracefully
  }
  }
}
