import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { takeUntil } from 'rxjs';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';

@Component({
  selector: 'app-active-tickets',
  templateUrl: './active-tickets.component.html',
  styleUrls: ['./active-tickets.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AdminTicketTableComponent]
})
export class ActiveTicketsComponent extends Unsub implements OnInit {
  activeTickets: any;
  public activeTicketsList: any;
  setting;
  timezone;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  permission: any;
  isloader = true;

  constructor(
    private adminService: AdminService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.activeticket();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.activeticket();

      }
    });
  }
  activeticket() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.adminService
      .activeticket(1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next:
          (ele: any) => {
            this.permission = ele.permissions;
            this.activeTicketsList = ele;

            this.activeTickets = ele.queryList;
            this.timezone = ele?.timezonedata;

            this.setting = ele.setting?.original;
            // Assign the data to the data source for the table to render
            this.isloader = false;
            if (!this.permission?.includes('Ticket Delete')) {
              this.displayedColumns = [
                'id',
                'ticketdetails',
                'user',
                'status',
                'assignto',
                'actions',
              ];

            }
            this.loaderService.hideLoader();
          },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        },
      }
      );
  }

  ngAfterViewInit() { }

  loadData(params) {
    this.isloader = true;
    this.adminService.activeticket(params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }
}
