import { Component } from '@angular/core';
import { FormsModule, NgForm } from '@angular/forms';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';


@Component({
  selector: 'app-customergoogle2fa',
  templateUrl: './customergoogle2fa.component.html',
  styleUrls: ['./customergoogle2fa.component.scss'],
  standalone : true,
  imports: [CommonModule, TranslatePipes, FormsModule, AnnouncementHolidayBannerComponent, RouterLink, NgbAlertModule]
})
export class Customergoogle2faComponent extends Unsub {
  email;
  data;
  redireurl;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  // otpverify

  constructor(private customerService: CustomersService,
    private sanitizer: DomSanitizer,
    private router: Router,
    private cookieService: CookieService, loaderService: LoaderService, private toastr: ToastrService, private translate: TranslatePipe, private activatedRoute: ActivatedRoute) {
    super(loaderService);
    this.redireurl = this.activatedRoute.snapshot.queryParams['returnUrl'];
    this.activatedRoute.paramMap
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (params) => {
          this.email = params.get('id');
          this.customerService.google2faauth(this.email).subscribe(res => {
            if (res) {
              this.data = res;
              if (res.success) {
                let url = this.redireurl ? this.redireurl : '/customer/dashboard'
                this.router.navigate([url]);
              }
              
              res.announcement?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.announcements?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.holidays?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
            }
          });
        }
      })
  }
  customergoogle2FaFn(ngform: NgForm, buttonId) {
    let data = {
      email: this.email,
      one_time_password: ngform.value.one_time_password
    };
    this.sendingResponse[buttonId] = true;
    this.customerService.google2faauthlogin(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            let url = this.redireurl ? this.redireurl : '/customer/dashboard'
            this.router.navigate([url]);
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }

}
