import { Component, OnInit } from '@angular/core';
import { Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CaptchaService } from '../../../../shared/services/admin/captcha.service';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgbAlertModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';
import { SharedModule } from '../../../../shared/shared.module';

@Component({
  selector: 'app-register',
  templateUrl: './register.component.html',
  styleUrls: ['./register.component.scss'],
  standalone : true,
  imports: [CommonModule, FormsModule, TranslatePipes, RecaptchaModule, RecaptchaV3Module, NgSelectModule, NgbTooltipModule, RouterLink, NgbAlertModule, AnnouncementHolidayBannerComponent, SharedModule]
})
export class CustomerRegisterComponent extends Unsub implements OnInit {
  data;
  public sendingResponse: { [key: string]: boolean } = {};
  captchaStatus:boolean = false;
  captcha: any;
  hideAlertsUntil: { [key: string]: number } = {};
  constructor(
    private customerService: CustomersService,
    private toastr: ToastrService,
    private router: Router,
    private cookieService: CookieService,
    private translate: TranslatePipe,
    private captchService : CaptchaService,
    loaderService: LoaderService,  private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.loaderService.showLoader();
    this.customerService
      .getregister()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.data = res;
          if (res) {
            res.announcement?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
            res.announcements?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
            res.holidays?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
          }
          if (res?.customfields) {
            res.customfields.forEach((element) => {
              if (
                (element.fieldtypes == 'radio' ||
                  element.fieldtypes == 'checkbox') && element.status == 1
              ) {
                this.customfield['custom_' + element.id] = {
                  status: element.fieldrequired,
                };
                if (element.fieldrequired == 1) {
                  this.checkStatus = true;
                }
              }
            });
          }
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  register(ngForm, buttonId) {
    const cf = this.customfield;
    const newCf = {};
    for (const i in cf) {
      const e = cf[i].val;
      newCf[i] = e;
    }
    if (ngForm.valid && !this.checkStatus) {
      this.sendingResponse[buttonId] = true;

      const data = { ...ngForm.value, ...newCf };
      data['agree_terms'] = ngForm.value.agree_terms ? 'agreed' : '';

      if (this.data?.setting?.original?.CAPTCHATYPE=='manual' && this.data?.setting?.original?.RECAPTCH_ENABLE_REGISTER == 'yes') {
        if (!this.captchaStatus) {
          this.toastr.error(this.translate.transform('Captcha Invalid'));
          this.sendingResponse[buttonId] = false;
          return;
        }
      }
      if (this.captchaStatus) {
        data['captcha'] = 'valid';
      }
      if (this.data?.setting?.original?.REGISTER_DISABLE == 'off') {
        this.toastr.error(this.translate.transform(this.data?.setting?.original?.login_disable_statement));
        this.sendingResponse[buttonId] = false;
      } else {
        this.customerService
          .customerRegister(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res?.success) {
                this.toastr.success(this.translate.transform(res.success));
                this.router.navigate(['/customer/login']);
              }
              if (res?.error?.errors) {
                for (const el in res.error.errors) {
                  this.toastr.error(this.translate.transform(res.error.errors[el]));
                }
              } else if (res?.error) {
                this.toastr.error(this.translate.transform(res.error));
              }
              this.captchService.setCaptchaStatus(false);

            },
            error: () => {
              this.sendingResponse[buttonId] = false;
              this.captchService.setCaptchaStatus(false);
            },
          });
      }
    }
  }

  customfield = {};
  checkStatus = false;
  checkCount: any[] = [];
  customfieldSection(res, name, type): void {
    this.checkStatus = true;
    this.checkCount = [];
    if (type == 'radio') {
      this.customfield[name].val = res;
    }
    if (type == 'checkbox') {
      if (this.customfield[name].val?.includes(res)) {
        this.customfield[name].val = this.customfield[name].val.filter((x) => {
          return x != res;
        });
      } else {
        if (this.customfield[name].val) {
          this.customfield[name].val.push(res);
        } else {
          this.customfield[name].val = [res];
        }
      }
    }
    for (const i in this.customfield) {
      if (this.customfield[i].status == 1) {
        if (this.customfield[i]?.val?.length) {
          continue;
        } else {
          this.checkCount.push(this.customfield[i]);
        }
      }
    }
    if (this.checkCount.length) {
      this.checkStatus = true;
    } else {
      this.checkStatus = false;
    }
  }

  public resolved(captchaResponse: string | any): void {
    this.captcha = captchaResponse;
  }
  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if(!value?.optional){
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if(value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      }else{
        this.captchaStatus = false;
      }
    }
  }

}
