import { Component } from '@angular/core';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { Unsub } from '../../../shared/class/unsub.class';
import { Router, ActivatedRoute } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslationService } from '../../../shared/services/translation.service';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-custom-invoice-pay',
  standalone: true,
  imports: [TranslatePipes, FormsModule],
  templateUrl: './custom-invoice-pay.component.html',
  styleUrl: './custom-invoice-pay.component.scss'
})
export class CustomInvoicePayComponent extends Unsub {
  usercurrency;
  usersymbol;
  transaction;
  setting;
  id;
  subTotal = 0;
  url = "";

  constructor(
    private customersService: CustomersService,
    private toastr: ToastrService, private router: Router,
    private translate: TranslatePipe,
    private activeRoute: ActivatedRoute,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
  }
  ngOnInit(): void {
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.allProjects(this.id);
      },
    });
  }
  allProjects(id) {
    this.loaderService.showLoader();
    this.customersService
      .customInvoicePay(id)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next:
          (res) => {
            this.transaction = res.transaction;
            this.setting = res.setting;
            this.usersymbol = res.usersymbol;
            this.usercurrency = res.usercurrency;
            this.loaderService.hideLoader();

            this.transaction?.custom_invoice_elements?.map(e => {
              this.subTotal += (e.price * e.quantity);
            })
          },
        error: () => {
          this.loaderService.hideLoader()
        },
      }
      );
  }

  getCurrencyPerTicket = (price) => {
    let final = '';
    const total = (price * this.usercurrency?.conversion_factor).toFixed(2);
    if (this.usercurrency?.position == 'Prefix') {
      final = this.usersymbol + '' + total;
    } else {
      final = total + '' + this.usersymbol;
    }
    return final;
  }

  checkoutFn(ngForm, buttonId) {
    this.customersService
      .invoiceCheckout$(ngForm.value)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res.session_id) {
            window.location.href = res.session_id;
            return;
          }
          if (res.paypalLink) {
            window.location.href = res.paypalLink;
            return;
          }
          if (res.error) {
            this.toastr.error(this.translate.transform(res.error))
            return;
          }
          if (res.paypalError) {
            this.toastr.error(this.translate.transform(res.paypalError))
            return;
          }
        }
      });
  }
}
