import { Routes } from "@angular/router";

export const customer: Routes = [
  {
    path: '',
    children: [
      {
        path: 'active-tickets',
        loadComponent:()=>import('./active-tickets/active-tickets.component').then(e =>e.ActiveTicketsComponent), data: {
          permission: true
        }
      },
      {
        path: 'closed-tickets',
        loadComponent:()=>import('./closed-tickets/closed-tickets.component').then(e =>e.ClosedTicketsComponent), data: {
          permission: true
        }
      },
      {
        path: 'create-tickets',
        loadComponent:()=>import('./create-ticket/create-ticket.component').then(e =>e.CreateTicketComponent), data: {
          permission: true
        }
      },
      {
        path: 'dashboard',
        loadComponent:()=>import('./dashboard/dashboard.component').then(e =>e.DashboardComponent), data: {
          permission: true
        }
      },
      {
        path: 'edit-profile',
        loadComponent:()=>import('./editprofile/editprofile.component').then(e =>e.EditprofileComponent), data: {
          permission: true
        }
      },
      {
        path: 'notifications/:id',
        loadComponent:()=>import('./notifications/notifications.component').then(e =>e.NotificationsComponent), data: {
          permission: true
        }
      },
      {
        path: 'onhold-tickets',
        loadComponent:()=>import('./onhold-tickets/onhold-tickets.component').then(e =>e.OnholdTicketsComponent), data: {
          permission: true
        }
      },
      {
        path: 'allnotifications',
        loadComponent:()=>import('./notifications/allnotifications/allnotifications.component').then(e =>e.AllnotificationsComponent), data: {
          permission: true
        }
      },
      {
        path: 'quotations',
        loadComponent:()=>import('./quotations/quotations.component').then(e =>e.QuotationsComponent), data: {
          permission: true
        }
      },
      {
        path: 'refunds',
        loadComponent:()=>import('./refunds/refunds.component').then(e =>e.RefundsComponent), data: {
          permission: true
        }
      },
      {
        path: 'transactions',
        loadComponent:()=>import('./transactions/transactions.component').then(e =>e.TransactionsComponent), data: {
          permission: true
        }
      },
      {
        path: 'invoices',
        loadComponent:()=>import('./invoices/invoices.component').then(e =>e.InvoicesComponent), data: {
          permission: true
        }
      },
    ],
  },
];
