import { Location } from '@angular/common';
import { Component } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
@Component({
  selector: 'app-customeremailupdate',
  templateUrl: './customeremailupdate.component.html',
  styleUrls: ['./customeremailupdate.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink, FormsModule,],
  providers : [TranslatePipes]
})
export class CustomeremailupdateComponent extends Unsub {
  email = '';
  showmail = true;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(private activatedRoute: ActivatedRoute, private customerService: CustomersService, private toastr : ToastrService, private translate : TranslatePipe,
    private router: Router,
    private state: Location,
    loaderService: LoaderService){
    super(loaderService);
    this.activatedRoute.paramMap.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (params) => {
        this.email = params.get('email') || '';
      },
    });
    }
    updateEmail(ngForm, buttonId){
      this.sendingResponse[buttonId] = true;
      let data = ngForm.value;
      data.oldemail = this.email;
      this.customerService.customernewemailstore(data).subscribe({
        next : (res) => {
          if(res.success){
            this.toastr.success(this.translate.transform(res.success))
            this.showmail = false;
          }
          if(res.error){
            this.toastr.error(this.translate.transform(res.error))
          }
          this.sendingResponse[buttonId] = false;
        },
        error : err => {
          this.sendingResponse[buttonId] = false;
        }
      })
    }
    checkOtp(ngForm, buttonId){
      this.sendingResponse[buttonId] = true;
      let data = ngForm.value;
      this.customerService.emailchangeotpverify(this.email, data).subscribe({
        next : (res) => {
          if (res?.success && !res?.redirect) {
            this.toastr.success(this.translate.transform(res.success));
            this.router.navigate(['/customer/login'], {
              queryParams: {
                returnUrl: this.state.path(),
              },
            });
          }
          if (res?.success && res?.redirect) {
            this.toastr.success(this.translate.transform(res.success));
            this.router.navigate(['/']);
          }
          if(res.error){
            this.toastr.error(this.translate.transform(res.error))
          }
          this.sendingResponse[buttonId] = false;
        },
        error : err => {
          this.sendingResponse[buttonId] = false;
        }
      })
    }

}
