import { HttpHeaders } from '@angular/common/http';
import { ChangeDetectorRef, Component, ElementRef, OnInit, QueryList, ViewChild, ViewChildren } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule } from '@angular/forms';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import Swal from 'sweetalert2';
import { CommonModule, Location } from '@angular/common';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../shared/services/loader.service';
import moment from 'moment-timezone';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { NgxMatIntlTelInputComponent } from 'ngx-mat-intl-tel-input';

@Component({
  selector: 'app-editprofile',
  templateUrl: './editprofile.component.html',
  styleUrls: ['./editprofile.component.scss'],
  standalone : true,
  imports : [CommonModule, TranslatePipes, NgSelectModule, FormsModule, NgxMatIntlTelInputComponent]
})
export class EditprofileComponent extends Unsub implements OnInit {
  @ViewChild('twofactorEle', { static: false }) twofactorEle!: ElementRef;
  @ViewChild('twilioSetting', { static: false }) twilioSetting!: ElementRef;
  @ViewChild('emailtwofactorEle', { static: false }) emailtwofactorEle!: ElementRef;
  @ViewChild('TwoFactorAuthentication', { static: false }) TwoFactorAuthentication!: ElementRef;
  @ViewChild('emailtwofac', { static: false }) emailtwofac!: ElementRef;
  @ViewChild('configured', { static: false }) configured!: ElementRef;
  @ViewChild('profileImg') profileImg!: ElementRef;
  timezones;
  timezone;
  reconfigureStatus = true;
  emailtwofactStatus = true;
  workingmodeStatus = true;
  user;
  custMobileNumber;
  OTPMobile;
  setting;
  public sendingResponse: { [key: string]: boolean } = {};
  pswd = true;
  form: FormGroup;
  isvalidNumber = false;
  public AdminID: any;
  customfield: any;
  userhasPswd: boolean = false;
  profileRemoved: any;
  constructor(
    private customersService: CustomersService,
    private toastr: ToastrService,
    public fb: FormBuilder,
    private cdRef: ChangeDetectorRef,
    private router: Router,
    private translate: TranslatePipe,
    private state: Location,
    private adminService: AdminService,
    private sanitizer: DomSanitizer,
    private modalService: NgbModal,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.form = this.fb.group({
      image: null,
    });
    this.timezones = moment.tz.names();
  }

  public countries: any;

  ngOnInit(): void {
    this.profile();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.profile();
      },
    });
  }
  profile() {
    this.loaderService.showLoader();
    this.customersService
      .profile()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele) => {
          this.countries = ele.countries;
          this.customfield = ele.customfield;
          this.user = ele.users;
          this.custMobileNumber = this.user?.phone
          this.timezone = ele.users.timezone;
          this.setting = ele.setting?.original;
          this.AdminID = ele.users.id;
          this.userhasPswd = ele.userhasPswd;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }
  updateReceiveStatus(event){
    let status = event.target?.checked;
    let data = {
      'custsmsenabledata': status,
      'cust_id': this.user.id
    };
    
    if(this.user?.phoneVerified == 0){
      this.toastr.error(this.translate.transform('First you need verify your mobile number in the profile details.'));
      this.twilioSetting.nativeElement.checked = false;     
      return;
    }
    this.customersService.custtwiliosetting(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (ele) => {
        this.toastr.success(this.translate.transform('Updated Successfully'));
      },
      error: (error) => {
        this.toastr.error(this.translate.transform('Failed to Update'));
      }
    });
  }
  autgoogleAuth = {
    QR_Image: "",
    secret: "",
    success: "",
    workprogress: ""
  }
  googletwofactorData = {}
  configureAuth(content, configStatus?) {
    let status = this.twofactorEle.nativeElement.checked;
    this.googletwofactorData = {
      "cust_id": this.AdminID,
      "twofactor": status
    }
    if (!configStatus) {
      if(this.setting?.Customer_email_two_fact == 'on' && this.user?.custsetting?.twofactorauth == 'emailtwofact'){
        Swal.fire({
          icon: 'warning',
          title: this.translate.transform('Are you sure?'),
          text: this.translate.transform('If you want to Enable Google Two Factor Need to disable the Email Two factor Authentication'),
          reverseButtons: true,
        }).then((result: any) => {

        })
        this.twofactorEle.nativeElement.checked = false;      
        return;
      }
      this.reconfigureStatus = true;
    }
     const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
      modalRef.result.then(
        () => {
        },
        (res) => {
          if (!configStatus && res == 'Cross click') {
            this.twofactorEle.nativeElement.checked = !this.twofactorEle.nativeElement.checked;
          }
        }
      )
      return;
  }
  verifyGoogleAuth(otp) {
    let data = {
      'otp': otp.value,
      'id': this.AdminID,
      'secret_key_value': this.autgoogleAuth.secret
    }
    this.customersService.google2faotpverify(data).subscribe(res => {
      if (res?.error) {
        this.toastr.error(this.translate.transform('Invalid otp'));
        this.workingmodeStatus = true;
      }
      if (res?.success) {

        this.autgoogleAuth = {
          QR_Image: "",
          secret: "",
          success: "",
          workprogress: ""
        }
        this.toastr.success(this.translate.transform('GoogleTwo factor authentication activated'));
        this.workingmodeStatus = false;
        this.reconfigureStatus = true;
      }
    })
  }
  removeAuth(content) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
  }
  
  sprukoemailtwofactor(ele, content) {
    if(this.setting?.Customer_google_two_fact == 'on' && this.user?.custsetting?.twofactorauth == 'googletwofact'){
      Swal.fire({
        icon: 'warning',
        title: this.translate.transform('Are you sure?'),
        text: this.translate.transform('If you want to Enable Email Two Factor Need to disable the Google Two factor Authentication'),
        reverseButtons: true,
      }).then((result: any) => {

      })
      this.emailtwofactorEle.nativeElement.checked = false;      
      return;
    }
    
    this.reconfigureStatus = false;
    this.emailtwofactStatus = true;
    if (this.twofactorEle) {
      this.twofactorEle.nativeElement.checked = false;
    }
    let status = ele.target?.checked;
    this.emailtwofactordata = {
      "cust_id": this.AdminID,
      "emailtwofact": status
    }
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
      },
      (res) => {
        if(res == 'Cross click'){
          this.emailtwofactorEle.nativeElement.checked = !this.emailtwofactorEle.nativeElement.checked;
        }
      }
    )
    return;
  }
  emailtwofactordata = {};
  twofactoremail(ngForm, buttonId){
    let data = this.emailtwofactordata;
    data['password'] = ngForm.value.password;
    this.autgoogleAuth = {
      QR_Image: "",
      secret: "",
      success: "",
      workprogress: ""
    }
    this.customersService.emailtwofactorcustomerset(data).subscribe(res => {
        this.sendingResponse[buttonId] = false;
        if (res?.success) {
          this.emailtwofactordata = {};      
          this.toastr.success(this.translate.transform(res.success));
          this.modalService.dismissAll();
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
    })
  }
  googleTwofactorDisable(ngForm, buttonId){
    let data = this.googletwofactorData;
    data["cust_id"] = this.AdminID;
    data['password'] = ngForm.value.password;

    this.customersService.google2faauthnew(data).subscribe(res => {
      if (res?.success) {
        this.googletwofactorData = {}; 
        if (res?.workprogress == "notworkingmode") {
          this.toastr.success(res.success);
          this.workingmodeStatus = false;
          this.reconfigureStatus = false;
        }
        else if (res?.workprogress == "workingmode") {
          this.emailtwofactorEle.nativeElement.checked = false;
          this.autgoogleAuth = res;
          this.workingmodeStatus = true;
          this.toastr.success(res.success);
          this.reconfigureStatus = false;
        }
        this.modalService.dismissAll();
      }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
    })
  }
  image(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.form.patchValue({
      image: file,
    });
  }
  SwitchToDarkMode(ele: any) {
    const putData = {
      "dark": ele.currentTarget?.checked ? 1 : 0,
      "cust_id": this.AdminID,
    };
    this.customersService
      .usersettings(putData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.toastr.success(this.translate.transform(res.success));
        }
      });
  }
  public timeZoneChanged(timeZone: string): void {
    this.timezone = timeZone;
  }

  ChangeTheValues(ngForm: any, buttonId) {
    if (ngForm.valid) {

      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('image', this.form.controls['image'].value);
      formData.append('country', ngForm.value.country);
      if(this.setting?.cust_mobile_update == 'on' && this.user.phone){
        formData.append('phone', this.user.phone);
      }
      formData.append('timezone', ngForm.value.timezone);
      formData.append('profileRemoved', this.profileRemoved);

      const httpOptions = {
        headers: new HttpHeaders({
          Accept: 'application/json',
        }),
      };
      this.customersService
        .profilesetup(formData, httpOptions)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.profileImg.nativeElement.value = "";
              this.toastr.success(this.translate.transform(res.success));
              this.form.reset({});
            } else {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  updateModel(content: any) {

    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(

      () => {
        this.cdRef.detectChanges()
      },
      // () => this.assignedMem = []
    ); 
  }
  sendOTP(buttonId){
    let data = {
      phone : this.custMobileNumber
    }
    this.customersService.sendotpPhoneUpdate(data).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
          this.newNumber = res.number;
          this.isvalidNumber = true;
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
        // if (res?.errors?.phone) {
        //   this.toastr.error(this.translate.transform(res.error));
        // }
      },
      error: () => {
        this.sendingResponse[buttonId] = false;
      },
    })
  }
  newNumber = "";
  customeremailchange(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      data.email = this.user?.email;
      this.customersService
        .customeremailchange(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  verifyOtp(event) {
    let value = event;
    if(value.length == 6){
        let data = {
          'otp': value,
          'phone': this.newNumber,
        }
        this.customersService
          .customermobilechange(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              if (res?.success) {
                this.toastr.success(this.translate.transform(res.success));
                this.modalService.dismissAll();
              }
              if (res?.error) {
                this.toastr.error(this.translate.transform(res.error));
              }
            },
            error: () => {
            },
          });
      // }

    }
  }
  changePassword(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;

      this.customersService
        .changePswd(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success && !res?.redirect) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/customer/login'], {
                queryParams: {
                  returnUrl: this.state.path(),
                },
              });
            }
            if (res?.success && res?.redirect) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/']);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  newPassword;
  generatePswd() {
    this.newPassword =
      Math.random().toString(36).slice(2) +
      Math.random().toString(36).toUpperCase().slice(2);
  }

  deleteaccount(deleteForm) {
    const data = {
    };
    if (deleteForm.valid) {
      Swal.fire({
        icon: 'warning',
        title: this.translate.transform('Are you sure ?'),
        text: this.translate.transform('Your will not be able to recover this!'),
        showCancelButton: true,
        confirmButtonColor: '#6259ca',
        cancelButtonColor: '#f11541',
        confirmButtonText: this.translate.transform('Yes, delete it!'),
        cancelButtonText: this.translate.transform('Close'),
        reverseButtons: true,
      }).then((result: any) => {
        if (result.isConfirmed) {
          this.customersService.deleteaccount(this.user.id, data).subscribe({
            next: (res) => {
              if (res?.success) {
                this.toastr.success(this.translate.transform(res.success));
                this.router.navigate(['/customer']);
              }

            }
          });
        }
      }
      );
    }
  }

  imageremove(id: any, ele, holder) {
    this.profileRemoved = id;
    ele.remove();
    holder.value = "";
  }

  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if (this.filterInput?.first) {
        this.filterInput.first.nativeElement.focus()
      }
    })
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
