import { Component, OnInit, ViewChild, ElementRef, HostListener, Renderer2, ChangeDetectorRef } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule, NgForm, ReactiveFormsModule } from '@angular/forms';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

import Swal from 'sweetalert2';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../shared/class/unsub.class';
import { customerToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { CommonModule } from '@angular/common';
import { NgbAccordionModule, NgbAlertModule, NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { NgxPrintElementComponent, NgxPrintElementDirective, NgxPrintElementService } from 'ngx-print-element';
import { CookieService } from 'ngx-cookie-service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { DateAgoPipe } from '../../../shared/pipes/date-ago/date-ago.pipe';
import { BusinessHourCardComponent } from '../../../shared/common/business-hour-card/business-hour-card.component';
import { CustomerTicketInfoComponent } from '../../../shared/common/includes/customer-ticket-info/customer-ticket-info.component';
import { CustomerPageHeaderComponent } from '../../../shared/common/pageheader/customer-page-header/customer-page-header.component';
import { CustomerHeaderComponent } from '../../../shared/common/header/customer-header/customer-header.component';
import { ImageUploadComponent } from '../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../shared/directives/max-length-validator.directive';
import { MinLengthValidatorDirective } from '../../../shared/directives/min-length-validator.directive';
import { SharedModule } from '../../../shared/shared.module';
import { AnnouncementHolidayBannerComponent } from '../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';
import { NgSelectModule } from '@ng-select/ng-select';
import { BusinessHourCardListComponent } from '../../../shared/common/business-hour-card-list/business-hour-card-list.component';

@Component({
  selector: 'app-ticket-view',
  templateUrl: './ticket-view.component.html',
  styleUrls: ['./ticket-view.component.scss'],
  standalone: true,
  imports: [CommonModule, TranslatePipes, DateAgoPipe, RouterLink, NgbTooltipModule, AngularEditorModule, NgbAccordionModule, NgbAlertModule,  NgxPrintElementDirective, FormsModule, ReactiveFormsModule, BusinessHourCardListComponent, CustomerTicketInfoComponent, CustomerPageHeaderComponent, CustomerHeaderComponent, ImageUploadComponent, MaxLengthValidatorDirective, MinLengthValidatorDirective, SharedModule, AnnouncementHolidayBannerComponent, NgSelectModule]
})
export class TicketViewComponent extends Unsub implements OnInit {
  @ViewChild('ticketReplyAcc') 'ticketReplyAcc'!: any;
  @ViewChild('custmermismatch') 'custmermismatch'!: ElementRef;
  @ViewChild('commentsClose') commentsClose!: ElementRef;
  @ViewChild('tableRef') tableElement!: ElementRef<HTMLTableElement>;
  url = "http://localhost/projects/angular/angular_uhelp_5.0/Uhelp/";
  data;
  details;
  Src;
  languages: any;
  id;
  public sendingResponse: { [key: string]: boolean } = {};
  ticketId;
  pageHeaderticketId;
  currentStatus = 'Inprogress'
  today: any = new Date();
  form: FormGroup;
  featureimage: any[] = [];
  ticketName: any[] = [];
  timezone: any;
  toolbar: AngularEditorConfig = customerToolbar;
  datacomments: any;
  businesshours;

  private intersectionObserver!: IntersectionObserver;
  public isLoadingComments: boolean = false;
  totalcomments: number = 0;
  setting: any;
  addspace;
  constructor(
    public print: NgxPrintElementService,
    private customerService: CustomersService,
    private toastr: ToastrService,
    private modalService: NgbModal,
    private activatedRoute: ActivatedRoute,
    public fb: FormBuilder,
    private cdr: ChangeDetectorRef,
    private router: Router,
    private adminService: AdminService,
    private cookieService: CookieService,
    private translate: TranslatePipe,
    private guestService: GuestService,
    loaderService: LoaderService, private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.activatedRoute.paramMap.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.getTicketDetails(this.id);
      },
    });

    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
    this.form = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        if (this.id) {
          this.pageCount = 1;
          this.getTicketDetails(this.id);
        }
      },
    });
  }
  customername;
  getTicketDetails(id) {
    this.loaderService.showLoader();
    this.customerService.showTicket(id, this.pageCount).pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        if (res?.noticket) {
          this.toastr.error(this.translate.transform(res.noticket));
          this.router.navigate(['/customer/dashboard']);
        }
        this.ticketId = res?.ticket?.id;
        this.addspace = res.addspace;
          this.businesshours = res.businesshours;
        this.pageHeaderticketId = res?.ticket?.ticket_id;
        this.data = res;

        res.holidays.forEach(alert => {
          const hideAlertsUntil = this.cookieService.get(alert.id);
          if (hideAlertsUntil) {
            this.hideAlertsUntils[alert.id] = parseInt(hideAlertsUntil, 10);
          }
        })
        if (this.data?.ticket?.status == 'New') {
          this.currentStatus = 'New';
        }
        else if (this.data?.ticket?.status == 'Re-Open' || this.data?.ticket?.status == 'Inprogress' || this.data?.ticket?.status == 'New' || this.data?.ticket?.status == 'Leave as current') {
          this.currentStatus = 'Inprogress';
        } else {
          this.currentStatus = this.data?.ticket?.status;
        }
        this.datacomments = res.comments.data;
        this.totalcomments = res.comments.total;
        this.pageCount = res.comments.current_page + 1;
        this.details = res.users;

        this.languages = Object.keys(res.languages).map(key => ({ id: key, name: res.languages[key] }));

        this.setting = res.setting?.original;
        this.Src = res.users.profileimage;
        this.timezone = res.timezonedata;
        this.customername = res?.ticket.cust.username;

        if (res.ticket.purchasecode != null && res.ticket.purchasecode != 'undefined') {
          this.verifyTicket(res?.ticket?.purchasecode);
        }
        this.loaderService.hideLoader();
        // Trigger change detection manually
        this.cdr.detectChanges();
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  purchasedata;
  verifyTicket(ticketData) {
    const data = {
      "envatopurchase_id": ticketData,
    };
    this.adminService.ticketuserlicenseverify(data).subscribe({
      next: (res) => {
        if (res.client?.trim() === this.customername?.trim()) {
          this.custmermismatch?.nativeElement.classList.add('d-none');
        } else {
          this.custmermismatch?.nativeElement.classList.remove('d-none');
        }
      },
    });
  }

  addDays(dateval, daysval) {
    const date = new Date(dateval);
    date.setDate(date.getDate() + Number(daysval));
    return date;
  }

  isWithinTimeLimit(commentCreatedDate: any): boolean {
    // return false;
    const custReplyEditWithinTime = this.setting.custreplyeditwithintime; // Replace with your desired time limit in minutes
    const commentCreatedAt = new Date(commentCreatedDate);
    const commentCreatedAtWithTimezone = new Date(commentCreatedAt.toLocaleString('en-US', { timeZone: this.setting.default_timezone }));
    const now = new Date();
    const nowWithTimezone = new Date(now.toLocaleString('en-US', { timeZone: this.setting.default_timezone }));
    const deadline = new Date(commentCreatedAtWithTimezone.getTime() + custReplyEditWithinTime * 60000);
    return deadline >= nowWithTimezone;
  }

  showEditForm(editreply) {
    editreply.classList.toggle('d-block');
  }

  updateReply(ngForm, id, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      this.customerService.updateTicket(id, data).pipe(
        takeUntil(this.unSubscribe$)
      ).subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            ngForm.reset();
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
    }
  }
  replyTicket(ngform: NgForm, buttonId) {
    if (ngform.valid) {
      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();

      for (const key of Object.keys(ngform.value)) {
        formData.append(key, ngform.value[key]);
      }
      formData.append('ticket_id', this.ticketId);
      formData.append('id', this.data?.ticket.enc_ticket_id);
      for (let i = 0; i < this.ticketName?.length; i++) {
        formData.append('comments[]', this.ticketName[i]);
      }

      this.customerService.replyTicket(this.id, formData).subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            ngform.reset();
            this.form.reset({});
            this.ticketReplyAcc?.collapseAll();
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
          if (res?.appreciate) {
            Swal.fire({
              icon: 'success',
              title: this.translate.transform(res.appreciate),
              confirmButtonColor: '#6259ca',
              confirmButtonText: this.translate.transform('Okay!'),
              reverseButtons: true,
            }).then((result: any) => { });
          }
          if (res?.rating) {
            this.router.navigate(['/rating-page/' + res.rating]);
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
    }
  }
  reopenTicket(buttonId) {
    this.sendingResponse[buttonId] = true;
    const data = {

    };
    this.customerService.TicketReopen(this.id, data).subscribe({
      next: (res) => {
        this.sendingResponse[buttonId] = false;
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
        }
      },
      error: () => {
        this.sendingResponse[buttonId] = false;
      },
    });
  }

  ngAfterViewInit() {

  }
  pageCount;

  loadComments() {
    // this.isloader = true;
    this.customerService.showTicket(this.id, this.pageCount)
      .subscribe((data: any) => {
        this.isLoadingComments = false;
        this.pageCount = data.comments.current_page + 1;
        this.datacomments = [...this.datacomments, ...data.comments.data];
      });
  }
  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }

  override ngOnDestroy() {
    if (this.intersectionObserver) {
      this.intersectionObserver.disconnect();
    }
  }


  downloadFile(id, image) {
    this.guestService.image(id, image).subscribe({
      next: (res: Blob) => {
        const blobUrl = window.URL.createObjectURL(res);
        const link = document.createElement('a');
        link.href = blobUrl;
        link.setAttribute('download', image); // Set a default filename, customize as needed
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        window.URL.revokeObjectURL(blobUrl);
      }
    })
  }
  printCustomerTicketView(el: ElementRef<HTMLTableElement | HTMLElement>) {
    this.print.print(el).subscribe({
      next: () => {
      }
    })

  }


  hideAlertsUntils: { [key: string]: number } = {};

  dismissAlert(alert, type) {
    const hideAlertsUntil = (Date.now() + (30 * 60 * 1000)).toString();
    this.cookieService.set(type + alert.id, hideAlertsUntil, undefined, '/'); // Set cookie for 30 minutes from now
    this.hideAlertsUntils[type + alert.id] = parseInt(hideAlertsUntil, 10);
  }

  isAlertVisible(alert, type) {
    return !alert.dismissed && (!this.hideAlertsUntils?.[type + alert.id] || this.hideAlertsUntils?.[type + alert.id] < Date.now());
  }

  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
  // Function to add alpha channel to RGB color
  addAlphaChannel(rgbColor: string, alpha: number): string {
    // Extracting the RGB values
    const rgbValues = rgbColor.match(/\d+/g);
    if (rgbValues) {
      // Constructing the RGBA color value
      const rgbaColor = `rgba(${rgbValues[0]}, ${rgbValues[1]}, ${rgbValues[2]}, ${alpha})`;
      return rgbaColor;
    }
    return rgbColor;
  }



  selectComment;
  translateModel(content, comment) {
    this.selectComment = comment;
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
  }
  openModel(content){
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'md' });
  }

  translateFn(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      let data = {
        text: this.selectComment ? this.selectComment.comment : this.data?.ticket?.message,
        target_lang: ngForm.value.languages,
        user: 'customer',
      }
      this.adminService.translate(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
              
              const comment = this.datacomments.find(comment => comment.id === this.selectComment.id);
              if (comment) {
                comment.comment = res.translated_text;
              }else{
                this.data.ticket.message = res.translated_text;
              }
            }
            if (res.message) {
              this.toastr.error(this.translate.transform('Translation failed: ' + res.message));
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }
          },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      }
      );
    }
  }
}

