import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

@Component({
  selector: 'app-rating-page',
  templateUrl: './rating-page.component.html',
  styleUrls: ['./rating-page.component.scss'],
})
export class RatingPageComponent extends Unsub implements OnInit {
  ticket;
  public sendingResponse: { [key: string]: boolean } = {};
  id!: string | null;
  constructor(
    private guestService: GuestService,
    private activeRoute: ActivatedRoute,
    private toastr: ToastrService,
    private router: Router,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.loaderService.showLoader();
        this.guestService
          .ratingTicket(this.id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              if (res?.redirect == 'back') {
                this.router.navigate(['/customer/dashboard']);
              }
              this.ticket = res;
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void { }

  ticketRtng(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {

        ratingticket: 'star' + ngForm.value.ratingticket,
      };
      this.guestService
        .starrating(this.id, data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/customer/dashboard']);
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error.message));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
