import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { HttpClient } from '@angular/common/http';
import { TranslatePipe } from '@ngx-translate/core';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../shared/class/unsub.class';
import { customerToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { CaptchaService } from '../../../shared/services/admin/captcha.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { NgSelectModule } from '@ng-select/ng-select';
import { CookieService } from 'ngx-cookie-service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { ImageUploadComponent } from '../../../shared/common/includes/image-upload/image-upload.component';
import { MinLengthValidatorDirective } from '../../../shared/directives/min-length-validator.directive';
import { MaxLengthValidatorDirective } from '../../../shared/directives/max-length-validator.directive';
import { SharedModule } from '../../../shared/shared.module';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TimeconvertionPipe } from '../../../shared/pipes/timeconvertion/timeconvertion.pipe';
import { CommonModule, DatePipe, NgClass } from '@angular/common';
import { BusinessHourCardListComponent } from '../../../shared/common/business-hour-card-list/business-hour-card-list.component';

@Component({
  selector: 'app-submit-ticket',
  templateUrl: './submit-ticket.component.html',
  styleUrls: ['./submit-ticket.component.scss'],
  standalone: true,
  imports: [TranslatePipes, TimeconvertionPipe, RouterLink, AngularEditorModule, RecaptchaModule, RecaptchaV3Module, ImageUploadComponent, NgSelectModule, MinLengthValidatorDirective, MaxLengthValidatorDirective, FormsModule, SharedModule, DatePipe, NgClass, BusinessHourCardListComponent]
})
export class SubmitTicketComponent extends Unsub implements OnInit {
  @ViewChild('supportexpired') supportexpired!: ElementRef;
  @ViewChild('verifysupportexpired') verifysupportexpired!: ElementRef;
  hideAlertsUntils: { [key: string]: number } = {};
  setting;
  data;
  today = new Date();
  addspace;
  emailstored;
  url;
  envatoName;
  public sendingResponse: { [key: string]: boolean } = {};
  verifyotp;
  emailShow = true;
  showotpfiled = false;
  showdetail = false;
  captchaStatus: boolean = false;
  captcha: any;
  form: FormGroup;
  businesshours;
  toolbar: AngularEditorConfig = customerToolbar;
  featureimage: any[] = [];
  ticketName: any[] = [];
  constructor(
    private http: HttpClient,
    private guestService: GuestService,
    private adminService: AdminService,
    private router: Router,
    private modalService: NgbModal,
    private captchService: CaptchaService,
    private toastr: ToastrService,
    public fb: FormBuilder,
    private cookieService: CookieService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.loaderService.showLoader();
    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
    
    this.guestService
      .openTicket()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res?.customfields) {
            this.data = res;
            this.businesshours = res.businesshours;
            this.addspace = res.addspace;
            res.holidays.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get(alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntils[alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
            this.setting = res?.setting?.original;
            if(this.setting?.GUEST_TICKET_OTP && this.setting?.GUEST_TICKET_OTP != 'yes'){
              this.toolbar.editable = false;
            }
            res.customfields.forEach((element) => {
              if (
                (element.fieldtypes == 'radio' ||
                  element.fieldtypes == 'checkbox') && element.status == 1
              ) {
                this.customfield['custom_' + element.id] = {
                  status: element.fieldrequired,
                };
                if (element.fieldrequired == 1) {
                  this.checkStatus = true;
                }
              }
            });
          }
          if (res.error) {
            this.router.navigate(['/guest/guest-ticket-restrict']);
          }
          this.loaderService.hideLoader();
        },
        error: (err) => {
          if (err) {
            this.router.navigate(['/guest/guest-ticket-restrict']);
          }
          this.loaderService.hideLoader();
        }
      });
    this.form = this.fb.group({
      image: null,
    });
  }

  ngOnInit(): void {
  }

  openModel(content){
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'md' });
  }
  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }
  opennoOtpticket(ngForm: NgForm, buttonId) {
    const cf = this.customfield;
    const newCf = {};
    for (const i in cf) {
      const e = cf[i].val;
      newCf[i] = e;
    }
    if (
      this.haspurchasecode?.length
        ? this.licencekeyStatus && ngForm.valid && !this.checkStatus && !this.categoryStatus
        : ngForm.valid && !this.checkStatus && !this.categoryStatus
    ) {

      this.sendingResponse[buttonId] = true;

      if (this.setting?.CAPTCHATYPE == 'manual' && this.setting?.RECAPTCH_ENABLE_GUEST == 'yes') {
        if (!this.captchaStatus) {
          this.toastr.error(this.translate.transform('Captcha Invalid'));
          this.sendingResponse[buttonId] = false;
          return;
        }
      }
      const formData: any = new FormData();

      // Append ngform values if they are present and not 'envato_id'
      for (const key of Object.keys(ngForm.value)) {
        const val = ngForm.value[key];
        if ((key !== 'envato_id' ||  ngForm.value != "agree_terms") && val !== null && val !== undefined && val !== '') {
          formData.append(key, val);
        }
      }
      
      // Append newCf values if present
      for (const key of Object.keys(newCf)) {
        const val = newCf[key];
        if (val !== null && val !== undefined && val !== '' ) {
          formData.append(key, val);
        }
      }
      
      // Append other values conditionally
      if (this.licencekey) {
        formData.append('envato_id', this.licencekey);
      }
      if (this.envatoName) {
        formData.append('productname', this.envatoName);
      }
      if (this.licencesupport) {
        formData.append('envato_support', this.licencesupport);
      }
      
      // Append ticketName array values conditionally
      if (Array.isArray(this.ticketName)) {
        for (let i = 0; i < this.ticketName.length; i++) {
          if (this.ticketName[i]) {
            formData.append('ticket[]', this.ticketName[i]);
          }
        }
      }

      
      formData.append('agree_terms', ngForm.value.agree_terms ? 'agreed' : null);
      

      if (this.captchaStatus) {
        formData.append('captcha', 'valid');
      }
      this.guestService
        .openTicketwithoutotp(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate([
                '/guest/ticketdetails/' + res.ticket_id,
              ]);
              this.form.reset({});
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
            this.captchService.setCaptchaStatus(false);
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
            this.captchService.setCaptchaStatus(false);
          },
        });
    }
  }
  openOtpticket(ngForm: NgForm, buttonId) {
    const cf = this.customfield;
    const newCf = {};
    for (const i in cf) {
      const e = cf[i].val;
      newCf[i] = e;
    }
    if (
      this.haspurchasecode?.length
        ? this.licencekeyStatus && ngForm.valid && !this.checkStatus && !this.categoryStatus
        : ngForm.valid && !this.checkStatus && !this.categoryStatus
    ) {
      this.sendingResponse[buttonId] = true;


      const formData: any = new FormData();

      for (const key of Object.keys(ngForm.value)) {
        if (ngForm.value != "agree_terms" || key !== 'envato_id') {
          formData.append(key, ngForm.value[key]);
        }
      }
      for (const key of Object.keys(newCf)) {
        formData.append(key, newCf[key]);
      }
      formData.append('verifyotp', this.verifyotp);
      formData.append('email', this.emailstored);
      formData.append('envato_id', this.licencekey);
      formData.append('envato_support', this.licencesupport);
      for (let i = 0; i < this.ticketName.length; i++) {
        formData.append('ticket[]', this.ticketName[i]);
      }
      formData.append('agree_terms', ngForm.value.agree_terms ? 'agreed' : null);

      if (this.captchaStatus) {
        formData.append('captcha', 'valid');
      }

      this.guestService
        .openTicketwithotp(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate([
                '/guest/ticketdetails/' + res.ticket_id,
              ]);
              this.form.reset({});
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
            this.captchService.setCaptchaStatus(false);
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
            this.captchService.setCaptchaStatus(false);
          },
        });
    }
  }
  getOtp(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      this.emailstored = ngForm.value.email;
      const data = {

        email: this.emailstored,
      };
      this.guestService
        .emailsvalidate(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.showotpfiled = true;
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error?.errors?.email || res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  isValdating = false;
  verifyOtp(event: any) {
    const val = event.value;
    if (val.length == 6 && !this.isValdating) {
      this.isValdating = true;
      this.verifyotp = val;
      const data = {

        otpvalue: val,
      };
      this.guestService
        .verifyotp(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.isValdating = false;

            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.showotpfiled = false;
              this.showdetail = true;
              this.toolbar.editable = this.showdetail;
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: err => {
            this.isValdating = false;
          }
        });
    }
  }

  categoryStatus = false;
  category = [];
  subcategory = null;
  projects = null;
  userDetails;
  haspurchasecode = [];
  hassubcategoriess = [];
  hasproject = [];
  envatoId;
  categorychange(id) {
    this.categoryStatus = true;
    this.licencekey = '';
    this.subcategory = null;
    this.projects = null;
    this.projects = null;
    this.licencekey = '';
    this.licencesupport = null;
    const data = {
      "cat_id": id,
    };
    this.adminService.getCatagoryData(data).subscribe({
      next: (res) => {
        this.categoryStatus = false;
        if (res.ENVATO_ON == 'on') {
          this.haspurchasecode = res.envatosuccess;
        }
        this.hasproject = res.projects;
        this.hassubcategoriess = res.subcategories;
      },
    });
  }
  licencekey;
  licencekeyStatus = false;
  licencesupport;
  envatoVerify(event) {
    if (event.value?.trim()?.length == 36) {
      this.envatoId = event.value.trim();
      const data = {
        data: event.value,
      };
      this.adminService.envatoverify(data).subscribe({
        next: (res) => {
          if (res?.valid != 'true') {
            if (this.setting?.ENVATO_EXPIRED_BLOCK == 'on') {
              this.toastr.error(this.translate.transform(res.message));
              this.supportexpired?.nativeElement.classList.remove('d-none');
              this.verifysupportexpired?.nativeElement.classList.add('d-none');
            }
            if (this.setting?.ENVATO_EXPIRED_BLOCK == 'off') {
              this.supportexpired?.nativeElement.classList.remove('d-none');
              this.verifysupportexpired?.nativeElement.classList.add('d-none');

              this.toastr.warning(this.translate.transform(res.message));
              this.envatoName = res.name;
              this.licencekey = res.key;
              this.licencekeyStatus = true;
              this.licencesupport = res.valid;
            }
          }
          if (res?.valid == 'true') {
            this.toastr.success(this.translate.transform(res.message));
            this.envatoName = res.name;
            this.licencekey = res.key;
            this.licencekeyStatus = true;
            this.licencesupport = res.valid;
          }
        },
      });
    }
  }

  customfield = {};
  checkStatus = false;
  checkCount: any[] = [];
  customfieldSection(res, name, type): void {
    this.checkStatus = true;
    this.checkCount = [];
    if (type == 'radio') {
      this.customfield[name].val = res;
    }
    if (type == 'checkbox') {
      if (this.customfield[name].val?.includes(res)) {
        this.customfield[name].val = this.customfield[name].val.filter((x) => {
          return x != res;
        });
      } else {
        if (this.customfield[name].val) {
          this.customfield[name].val.push(res);
        } else {
          this.customfield[name].val = [res];
        }
      }
    }
    for (const i in this.customfield) {
      if (this.customfield[i].status == 1) {
        if (this.customfield[i]?.val?.length) {
          continue;
        } else {
          this.checkCount.push(this.customfield[i]);
        }
      }
    }
    if (this.checkCount.length) {
      this.checkStatus = true;
    } else {
      this.checkStatus = false;
    }
  }

  public resolved(captchaResponse: string | any): void {
    this.captcha = captchaResponse;
  }

  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if (!value?.optional) {
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if (value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      } else {
        this.captchaStatus = false;
      }
    }
  }
}
