import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-ticket-verify-otp',
  templateUrl: './ticket-verify-otp.component.html',
  styleUrls: ['./ticket-verify-otp.component.scss'],
  standalone : true,
  imports: [TranslatePipes, FormsModule, RouterLink]
})
export class TicketVerifyOtpComponent extends Unsub implements OnInit {
  ticketData: any;
  public sendingResponse: { [key: string]: boolean } = {};
  title;
  email;
  waitForSomeTime!: boolean;
  constructor(
    private guestService: GuestService,
    private toastr: ToastrService,
    private router: Router,
    private activedRoute: ActivatedRoute,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.loaderService.showLoader();
        this.guestService
          .ticketOtpDetails(params.get('id'))
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              if (res?.noticket) {
                this.toastr.error(this.translate.transform(res.noticket));
                this.router.navigate(['/']);
              }
              this.title = res.title;
              this.ticketData = res.ticket;
              this.email = res.ticket.cust.email;
              this.loaderService.hideLoader();
              const data = {

                email: this.email,
                id: this.ticketData.id,
              };
              this.guestService.sendotp(data)
              .pipe(takeUntil(this.unSubscribe$))
              .subscribe({
                next: (res) => {
                  if (res.success) {
                    this.toastr.success(this.translate.transform(res.success));
                  }
                  if (res?.error?.errors) {
                    for (const el in res.error.errors) {
                      this.toastr.error(this.translate.transform(res.error.errors[el]));
                    }
                  }
                }
              })
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void { }

  getOtp(event) {
    const data = {

      email: this.email,
      id: this.ticketData.id,
    };
    if (!this.waitForSomeTime) {

      this.guestService
        .sendotp(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));

              this.waitForSomeTime = true;
              event.innerText = "Please wait...";
              let count = 15;
              const interval = setInterval(() => {
                count--;
                if (count === 0) {
                  clearInterval(interval);
                  this.waitForSomeTime = false;
                  event.innerText = "Resend OTP";
                } else {
                  event.innerText = `Please wait... (${count})`;
                }
              }, 1000);
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
          },
        });
    }
  }

  verifyOtp(ngForm, buttonId) {
    const data = {
      otpvalue: ngForm.value.verifyguestotp,
    };
    this.sendingResponse[buttonId] = true;

    this.guestService
      .verifyguestotp(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
            this.router.navigate([
              '/guest/ticket/' + this.ticketData.enc_ticket_id,
            ]);
          }
          if (res.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
          if (res?.error?.errors) {
            for (const el in res.error.errors) {
              this.toastr.error(this.translate.transform(res.error.errors[el]));
            }
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
}
