import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { takeUntil } from 'rxjs';
import { LoaderService } from '../../../shared/services/loader.service';
import { Unsub } from '../../../shared/class/unsub.class';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-ticketdetails',
  templateUrl: './ticketdetails.component.html',
  styleUrls: ['./ticketdetails.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink]
})
export class TicketdetailsComponent extends Unsub implements OnInit {
  ticketId;
  constructor(private activeRoute: ActivatedRoute, loaderService: LoaderService) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.ticketId = params.get('id');
      },
    });
  }

  ngOnInit(): void {}
}
