import { ChangeDetectionStrategy, Component, Input, OnInit } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
@Component({
  selector: 'app-customer-footer',
  templateUrl: './customer-footer.component.html',
  styleUrls: ['./customer-footer.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class CustomerFooterComponent implements OnInit {
  @Input() footerDetails: any;
  constructor(private sanitizer: DomSanitizer) {
  }

  ngOnInit(): void {}
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
