import { Component } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { combineLatest, takeUntil } from 'rxjs';
import { Unsub } from '../../class/unsub.class';
import { GuestService } from '../../services/guest.service';
import { LoaderService } from '../../services/loader.service';

@Component({
  selector: 'app-emailtoticketimageurl',
  template: ``,
  styleUrls: ['./emailtoticketimageurl.component.scss']
})
export class EmailtoticketimageurlComponent extends Unsub{
  id = '';
  image = '';
  href;
  base;
  imageSrc!: string;
  constructor(private activedRoute: ActivatedRoute,
    loaderService: LoaderService){
    super(loaderService);
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');
    combineLatest([
      this.activedRoute.paramMap,
      this.activedRoute.queryParams
    ]).pipe(takeUntil(this.unSubscribe$)).subscribe(([routeParams, queryParams]) => {
      this.id = routeParams.get('id') || '';
      this.image = queryParams['image'] || '';
      this.viewImage();
    });
  }

  viewImage(){
    location.href= `${this.href}${this.base}detail/emailtoticket/${this.id}/${this.image}`;
  }
}
