import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, SimpleChanges } from '@angular/core';
import { FormBuilder, FormsModule } from '@angular/forms';
import { ActivatedRoute } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Unsub } from '../../../class/unsub.class';
import { LoaderService } from '../../../services/loader.service';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../pipes/translate/translate.pipe';
import { NgxDropzoneModule } from 'ngx-dropzone';

@Component({
  selector: 'app-image-upload',
  standalone: true,
  imports:[CommonModule, TranslatePipes, NgxDropzoneModule, FormsModule],
  templateUrl: './image-upload.component.html',
  styleUrls: ['./image-upload.component.scss']
})
export class ImageUploadComponent extends Unsub {
  @Input() directSize!:number;
  @Input() directTypes!:string;
  @Input() disabled!:boolean;
  @Input() setting: any;
  @Input() maxLength: any;
  // @Input() conversation: any;
  @Input() media: any;
  @Input() articlefeatureimage: any;
  @Output() onImageUploaded = new EventEmitter<any>();
  form: any;
  featureImage: any = [];
  ticketName: any = [];
  ngOnChanges(changes: SimpleChanges) {
    this.featureImage = [];
    if (changes?.['media']?.currentValue) {
      changes['media'].currentValue.map(e => {
        if(e?.articlefeatureimage){
          this.featureImage.push(e.articlefeatureimage)
        }
        else if(e?.profileimage){
          this.featureImage.push(e.profileimage)
        }
      })
    }
  }

  constructor(private translate: TranslatePipe, private toastr: ToastrService, private route: ActivatedRoute, loaderService: LoaderService,
    public fb: FormBuilder) {
    super(loaderService);
    this.form = this.fb.group({
      image: null,
    });
  }
  onImageUpload(event: any): void {
    // Check if any file was rejected
    if (event?.rejectedFiles?.length > 0) {
      this.showError('The file type is not supported');
      return;
    }

    // Get the supported file types from configuration
    const fileUpload = this.directTypes?.split(',') || this.setting?.FILE_UPLOAD_TYPES.split(',');
    // Check if the file type is supported
    const file = event.addedFiles?.[0];
    const fileExtension = file.name.split('.').pop();
    if (!fileUpload.includes(fileExtension)) {
      this.showError('The file type is not supported');
      return;
    }

    // Check if the file size is within the allowed limit
    const maxFileSize = this.directSize || this.setting?.FILE_UPLOAD_MAX;
    if (file.size / 1024 / 1024 > maxFileSize) {
      this.showError('The file size is too large');
      return;
    }

    // Check if the max files limit has been reached
    const maxFiles = this.setting?.MAX_FILE_UPLOAD;
    if (this.featureImage.length >= maxFiles) {
      this.showError('The max files limit has been reached');
      return;
    }
    if (this.featureImage.length >= this.maxLength) {
      this.showError('The max files limit has been reached');
      return;
    }

    // Upload the image
    const reader = new FileReader();
    reader.onload = () => {
      this.featureImage.push(reader.result);
    };
    reader.readAsDataURL(file);
    this.form.patchValue({ image: file });

    this.ticketName.push(this.form.controls['image'].value);
    this.onImageUploaded.emit({ ticketName: this.ticketName });
  }

  private showError(message: string): void {
    this.toastr.error(this.translate.transform(message), this.translate.transform('Error'));
  }

  onimageRemove(event: any, image, index) {
    event.preventDefault();
    event.stopPropagation()
    this.featureImage.splice(this.featureImage.indexOf(image), 1);
     this.ticketName?.splice(index, 1)
    const mediaid = this.media?.filter(e => e.profileimage === image);
    this.onImageUploaded.emit({ ticketName: this.ticketName,
       mediaremoveIds: mediaid });
  }
}
