import { ChangeDetectionStrategy, Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { CaptchaService } from '../../../services/admin/captcha.service';

@Component({
  selector: 'app-manualcaptcha',
  templateUrl: './manualcaptcha.component.html',
  styleUrls: ['./manualcaptcha.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class ManualcaptchaComponent implements OnInit {
  captcha = false;@
  Input() canvasId!: string;
  @Input() disabled!:boolean;
  @Output() captchaComplete = new EventEmitter<any>();
  constructor(private captchService: CaptchaService, private toastr: ToastrService,
    private translate: TranslatePipe) { }

  ngOnInit(): void {
    this.createCaptcha();
    this.captchService.captchStatus.subscribe((value) => {
      if (value) {
        this.captcha = true;
      }
      else {
        this.captcha = false;
        this.createCaptcha();
        this.captchInput = '';
      }
    });
  }

  // manual  
  captchInput: any = null;
  code: any = null;
  resultCode: any = null;
  config: any = {
    length: 6,
    back:{
      color : 'yellow'
    },
    font: {
      color: "#000000",
      size: "35px",
      family: "sans-serif",
    }
  };
  createCaptcha() {

    const num1 = Math.floor(Math.random() * 99);
    const num2 = Math.floor(Math.random() * 9);
    const operators = ['+', '-'];
    const operator = operators[(Math.floor(Math.random() * operators.length))];
    this.code = num1 + operator + num2 + '=?';
    this.resultCode = (operator == '+') ? (num1 + num2) : (num1 - num2);
    setTimeout(() => {
      const captcahCanvas: any = document.getElementById(this.canvasId);
      const ctx = captcahCanvas.getContext("2d");
      ctx.fillStyle = this.config.back.color;
      ctx.fillRect(0, 0, captcahCanvas.width, captcahCanvas.height);

      ctx.beginPath();
      captcahCanvas.style.letterSpacing = 15 + "px";
      captcahCanvas.style.height = 60 + "px";
      captcahCanvas.style.maxWidth = 320 + "px";
      captcahCanvas.style.width = 100 + '%';
      ctx.font = this.config.font.size + " " + this.config.font.family;
      ctx.fillStyle = this.config.font.color;
      ctx.textAlign = 'center';
      ctx.textBaseline = "middle";
      ctx.fillText(this.code, captcahCanvas.width / 2, captcahCanvas.height / 2);
      ctx.strokeStyle = '#2F9688';
      for (let i = 0; i < 50; i++) {
        ctx.moveTo(Math.random() * 240, Math.random() * 240);
        ctx.lineTo(Math.random() * 300, Math.random() * 300);
      }
      ctx.stroke();
    }, 500);
    this.captchInput = '';
    this.sendData(true);
  }

  playCaptcha() {
    const msg = new SpeechSynthesisUtterance(this.code?.split('').join(' '));
    msg.pitch = 0.2;
    window.speechSynthesis.speak(msg);
  }
  sendData(optional?) {
    if(optional){
      this.captchaComplete.emit({ 'input': this.captchInput, 'generated': this.resultCode, 'optional' : true });
    }else{
      this.captchaComplete.emit({ 'input': this.captchInput, 'generated': this.resultCode });
    }
  }
}
