import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

@Component({
  selector: 'app-read-more',
  templateUrl: './read-more.component.html',
  styleUrls: ['./read-more.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class ReadMoreComponent {
  @Input() content!: string;
  @Input() completeWords!: boolean;
  constructor(private sanitizer: DomSanitizer) { }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }

  isContentExpanded = this.completeWords || false;
  toggleContent() {
    this.isContentExpanded = !this.isContentExpanded;
  }
}