import { Component, Input, OnInit } from '@angular/core';
import { NavigationEnd, Router } from '@angular/router';
import { LoaderService } from '../../../services/loader.service';
import { Unsub } from '../../../class/unsub.class';
import { takeUntil } from 'rxjs';
import { TranslatePipes } from '../../../pipes/translate/translate.pipe';
import { CommonModule } from '@angular/common';

@Component({
  selector: 'customer-page-header',
  standalone: true,
  imports:[CommonModule, TranslatePipes],
  templateUrl: './customer-page-header.component.html',
  styleUrls: ['./customer-page-header.component.scss']
})
export class CustomerPageHeaderComponent extends Unsub implements OnInit  {
  // @Input('ticketId') ticketId: string | null;
  id;
  
  @Input() set ticketId(data: any) {
    this.id  = data;
    if(this.titles.includes('ticket-view') && this.id){
      let index = this.titles.indexOf('ticket-view');      
      this.titles[index + 1] = this.id;
    }
  }
   titles:string[] = [];
  constructor(private router : Router, 
    loaderService: LoaderService) {
    super(loaderService);
    this.router.events.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (event: any) => {
        if (event instanceof NavigationEnd) {
      // Get the current route's URL
          const currentUrl = event.url;

          // Remove leading and trailing slashes
          const trimmedUrl = currentUrl.replace(/^\/|\/$/g, '');

          // Remove the segment "customer"
          const urlWithoutCustomer = trimmedUrl.replace('customer', '');

          // Split the remaining string into an array of segments
          this.titles = urlWithoutCustomer?.split('/');

          // Filter out empty segments (e.g., if there were consecutive slashes)
          this.titles = this.titles.filter(segment => segment !== '');
          
        }
      }})
   }

  ngOnInit(): void {
  }
  
  isEncryptedSegment(segment: string): boolean {
    return segment.length > 20 && /^[A-Za-z0-9+/=]+$/.test(segment);
  }
}
