import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { TranslatePipes } from '../../pipes/translate/translate.pipe';
import { LoaderService } from '../../services/loader.service';
import { Unsub } from '../../class/unsub.class';
import { CustomersService } from '../../services/customers/customers.service';

@Component({
  selector: 'app-rating-page',
  templateUrl: './rating-page.component.html',
  styleUrls: ['./rating-page.component.scss'],
})
export class RatingPageComponent extends Unsub implements OnInit {
  ticket;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private customerService: CustomersService,
    private toastr: ToastrService,
    private router: Router,
    private activedRoute: ActivatedRoute,
    private translate: TranslatePipes,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activedRoute.paramMap
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (params) => {
          const token = params.get('id');
          this.customerService.rating(token).subscribe({
            next: (res) => {
              if (res?.redirect == 'back') {
                this.router.navigate(['/customer/dashboard']);
              }
              if (res?.error) {
                this.toastr.error(this.translate.transform(res.error));
                this.router.navigate(['/customer/dashboard']);
              }
              this.ticket = res.ticket;
            }
          });
        }
      });
  }

  ngOnInit(): void { }

  ratingTicket(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      data['ticket_id'] = this.ticket.id;

      this.customerService.ticketRating(data).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/customer/dashboard']);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      }
      );
    }
  }
}
